/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.List;
import java.util.Scanner;
import org.openimaj.feature.FloatFV;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.Location;
import org.openimaj.feature.normalisation.Normaliser;
import org.openimaj.util.array.ArrayUtils;

public class FloatLocalFeatureAdaptor<L extends Location>
implements LocalFeature<L, FloatFV> {
    LocalFeature<L, ?> localFeature;
    Normaliser<FloatFV> normaliser;

    public FloatLocalFeatureAdaptor(LocalFeature<L, ?> localFeature) {
        this.localFeature = localFeature;
    }

    public FloatLocalFeatureAdaptor(LocalFeature<L, ?> localFeature, Normaliser<FloatFV> normaliser) {
        this.localFeature = localFeature;
        this.normaliser = normaliser;
    }

    public void readASCII(Scanner in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String asciiHeader() {
        throw new UnsupportedOperationException();
    }

    public void readBinary(DataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] binaryHeader() {
        throw new UnsupportedOperationException();
    }

    public void writeASCII(PrintWriter out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBinary(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FloatFV getFeatureVector() {
        FloatFV fv = new FloatFV(ArrayUtils.convertToFloat((double[])((double[])this.localFeature.getFeatureVector().asDoubleFV().values)));
        if (this.normaliser != null) {
            this.normaliser.normalise(fv);
        }
        return fv;
    }

    @Override
    public L getLocation() {
        return (L)this.localFeature.getLocation();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FloatLocalFeatureAdaptor)) {
            return false;
        }
        return ((FloatLocalFeatureAdaptor)obj).localFeature.equals(this.localFeature);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localFeature == null ? 0 : this.localFeature.hashCode());
        return result;
    }

    public static <L extends Location> List<FloatLocalFeatureAdaptor<L>> wrap(List<? extends LocalFeature<L, ?>> list) {
        return FloatLocalFeatureAdaptor.wrap(list, null);
    }

    public static List<FloatLocalFeatureAdaptor<?>> wrapUntyped(List<? extends LocalFeature<?, ?>> list) {
        return FloatLocalFeatureAdaptor.wrapUntyped(list, null);
    }

    public static <L extends Location> List<FloatLocalFeatureAdaptor<L>> wrap(final List<? extends LocalFeature<L, ?>> list, final Normaliser<FloatFV> normaliser) {
        AbstractList out = new AbstractList<FloatLocalFeatureAdaptor<L>>(){

            @Override
            public FloatLocalFeatureAdaptor<L> get(int index) {
                return new FloatLocalFeatureAdaptor((LocalFeature)list.get(index), normaliser);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
        return out;
    }

    public static List<FloatLocalFeatureAdaptor<?>> wrapUntyped(final List<? extends LocalFeature<?, ?>> list, final Normaliser<FloatFV> normaliser) {
        AbstractList out = new AbstractList<FloatLocalFeatureAdaptor<?>>(){

            @Override
            public FloatLocalFeatureAdaptor<?> get(int index) {
                return new FloatLocalFeatureAdaptor((LocalFeature)list.get(index), normaliser);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
        return out;
    }
}

