/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FloatFVComparison;
import org.openimaj.util.concatenate.Concatenatable;

public class FloatFV
extends ArrayFeatureVector<float[]>
implements Concatenatable<FloatFV, FloatFV>,
Cloneable {
    private static final long serialVersionUID = 1L;

    public FloatFV() {
    }

    public FloatFV(int nbins) {
        this.values = new float[nbins];
    }

    public FloatFV(float[] values) {
        this.values = values;
    }

    public float get(int x) {
        return ((float[])this.values)[x];
    }

    void set(float value, int x) {
        ((float[])this.values)[x] = value;
    }

    @Override
    public DoubleFV normaliseFV(double[] min, double[] max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min[i];
            int n2 = i;
            dvals[n2] = dvals[n2] / (max[i] - min[i]);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double min, double max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min;
            int n2 = i;
            dvals[n2] = dvals[n2] / (max - min);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV() {
        int i;
        double[] dvals = this.asDoubleVector();
        double sum = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            sum += dvals[i];
        }
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / sum;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double p) {
        int i;
        double[] dvals = this.asDoubleVector();
        double pnorm = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            pnorm += Math.pow(dvals[i], p);
        }
        pnorm = Math.pow(pnorm, 1.0 / p);
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / pnorm;
        }
        return new DoubleFV(dvals);
    }

    public FloatFV clone() {
        try {
            FloatFV model = (FloatFV)super.clone();
            model.values = ((float[])this.values).clone();
            return model;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        String ret = this.getClass().getName() + Arrays.toString((float[])this.values);
        return ret;
    }

    @Override
    public DoubleFV asDoubleFV() {
        return new DoubleFV(this.asDoubleVector());
    }

    @Override
    public double[] asDoubleVector() {
        double[] d = new double[((float[])this.values).length];
        for (int i = 0; i < ((float[])this.values).length; ++i) {
            d[i] = ((float[])this.values)[i];
        }
        return d;
    }

    public double compare(FloatFV h, FloatFVComparison method) {
        return method.compare(this, h);
    }

    @Override
    public int length() {
        return ((float[])this.values).length;
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(((float[])this.values).length);
        for (int i = 0; i < ((float[])this.values).length; ++i) {
            out.writeFloat(((float[])this.values)[i]);
        }
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.println(((float[])this.values).length);
        for (int i = 0; i < ((float[])this.values).length; ++i) {
            out.print(((float[])this.values)[i] + " ");
        }
        out.println();
    }

    public void readBinary(DataInput in) throws IOException {
        int nbins = in.readInt();
        this.values = new float[nbins];
        for (int i = 0; i < nbins; ++i) {
            ((float[])this.values)[i] = in.readFloat();
        }
    }

    public void readASCII(Scanner in) throws IOException {
        int nbins = Integer.parseInt(in.nextLine());
        this.values = new float[nbins];
        String[] line = in.nextLine().trim().split(" ");
        for (int i = 0; i < nbins; ++i) {
            ((float[])this.values)[i] = Float.parseFloat(line[i]);
        }
    }

    public byte[] binaryHeader() {
        return (this.getClass().getName().substring(0, 2) + "FV").getBytes();
    }

    public String asciiHeader() {
        return this.getClass().getName() + " ";
    }

    public FloatFV concatenate(FloatFV ... ins) {
        int l = ((float[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            l += ((float[])ins[i].values).length;
        }
        float[] data = new float[l];
        System.arraycopy(this.values, 0, data, 0, ((float[])this.values).length);
        int offset = ((float[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            System.arraycopy(ins[i].values, 0, data, offset, ((float[])ins[i].values).length);
            offset += ((float[])ins[i].values).length;
        }
        return new FloatFV(data);
    }

    public FloatFV concatenate(List<FloatFV> ins) {
        int l = ((float[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            l += ((float[])ins.get((int)i).values).length;
        }
        float[] data = new float[l];
        System.arraycopy(this.values, 0, data, 0, ((float[])this.values).length);
        int offset = ((float[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            System.arraycopy(ins.get((int)i).values, 0, data, offset, ((float[])ins.get((int)i).values).length);
            offset += ((float[])ins.get((int)i).values).length;
        }
        return new FloatFV(data);
    }

    public int hashCode() {
        return Arrays.hashCode((float[])this.values);
    }

    public boolean equals(Object obj) {
        return Arrays.equals((float[])this.values, (float[])((FloatFV)obj).values);
    }

    public FloatFV subvector(int beginIndex) {
        return new FloatFV(Arrays.copyOfRange((float[])this.values, beginIndex, ((float[])this.values).length));
    }

    public FloatFV subvector(int beginIndex, int endIndex) {
        return new FloatFV(Arrays.copyOfRange((float[])this.values, beginIndex, endIndex));
    }
}

