/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.openimaj.feature.ArrayFeatureVector;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.util.concatenate.Concatenatable;

public class DoubleFV
extends ArrayFeatureVector<double[]>
implements Concatenatable<DoubleFV, DoubleFV>,
Cloneable {
    private static final long serialVersionUID = 1L;

    public DoubleFV() {
    }

    public DoubleFV(int nbins) {
        this.values = new double[nbins];
    }

    public DoubleFV(double[] values) {
        this.values = values;
    }

    public double get(int x) {
        return ((double[])this.values)[x];
    }

    void set(double value, int x) {
        ((double[])this.values)[x] = value;
    }

    @Override
    public DoubleFV normaliseFV(double[] min, double[] max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min[i];
            int n2 = i;
            dvals[n2] = dvals[n2] / (max[i] - min[i]);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double min, double max) {
        double[] dvals = this.asDoubleVector();
        for (int i = 0; i < dvals.length; ++i) {
            int n = i;
            dvals[n] = dvals[n] - min;
            int n2 = i;
            dvals[n2] = dvals[n2] / (max - min);
            if (dvals[i] < 0.0) {
                dvals[i] = 0.0;
            }
            if (!(dvals[i] > 1.0)) continue;
            dvals[i] = 1.0;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV() {
        int i;
        double[] dvals = this.asDoubleVector();
        double sum = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            sum += dvals[i];
        }
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / sum;
        }
        return new DoubleFV(dvals);
    }

    @Override
    public DoubleFV normaliseFV(double p) {
        int i;
        double[] dvals = this.asDoubleVector();
        double pnorm = 0.0;
        for (i = 0; i < dvals.length; ++i) {
            pnorm += Math.pow(dvals[i], p);
        }
        pnorm = Math.pow(pnorm, 1.0 / p);
        i = 0;
        while (i < dvals.length) {
            int n = i++;
            dvals[n] = dvals[n] / pnorm;
        }
        return new DoubleFV(dvals);
    }

    public DoubleFV clone() {
        try {
            DoubleFV model = (DoubleFV)super.clone();
            model.values = ((double[])this.values).clone();
            return model;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        String ret = this.getClass().getName() + Arrays.toString((double[])this.values);
        return ret;
    }

    @Override
    public DoubleFV asDoubleFV() {
        return new DoubleFV(this.asDoubleVector());
    }

    @Override
    public double[] asDoubleVector() {
        double[] d = new double[((double[])this.values).length];
        for (int i = 0; i < ((double[])this.values).length; ++i) {
            d[i] = ((double[])this.values)[i];
        }
        return d;
    }

    public double compare(DoubleFV h, DoubleFVComparison method) {
        return method.compare(this, h);
    }

    @Override
    public int length() {
        return ((double[])this.values).length;
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(((double[])this.values).length);
        for (int i = 0; i < ((double[])this.values).length; ++i) {
            out.writeDouble(((double[])this.values)[i]);
        }
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.println(((double[])this.values).length);
        for (int i = 0; i < ((double[])this.values).length; ++i) {
            out.print(((double[])this.values)[i] + " ");
        }
        out.println();
    }

    public void readBinary(DataInput in) throws IOException {
        int nbins = in.readInt();
        this.values = new double[nbins];
        for (int i = 0; i < nbins; ++i) {
            ((double[])this.values)[i] = in.readDouble();
        }
    }

    public void readASCII(Scanner in) throws IOException {
        int nbins = Integer.parseInt(in.nextLine());
        this.values = new double[nbins];
        String[] line = in.nextLine().trim().split(" ");
        for (int i = 0; i < nbins; ++i) {
            ((double[])this.values)[i] = Double.parseDouble(line[i]);
        }
    }

    public byte[] binaryHeader() {
        return (this.getClass().getName().substring(0, 2) + "FV").getBytes();
    }

    public String asciiHeader() {
        return this.getClass().getName() + " ";
    }

    public DoubleFV concatenate(DoubleFV ... ins) {
        int l = ((double[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            l += ((double[])ins[i].values).length;
        }
        double[] data = new double[l];
        System.arraycopy(this.values, 0, data, 0, ((double[])this.values).length);
        int offset = ((double[])this.values).length;
        for (int i = 0; i < ins.length; ++i) {
            System.arraycopy(ins[i].values, 0, data, offset, ((double[])ins[i].values).length);
            offset += ((double[])ins[i].values).length;
        }
        return new DoubleFV(data);
    }

    public DoubleFV concatenate(List<DoubleFV> ins) {
        int l = ((double[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            l += ((double[])ins.get((int)i).values).length;
        }
        double[] data = new double[l];
        System.arraycopy(this.values, 0, data, 0, ((double[])this.values).length);
        int offset = ((double[])this.values).length;
        for (int i = 0; i < ins.size(); ++i) {
            System.arraycopy(ins.get((int)i).values, 0, data, offset, ((double[])ins.get((int)i).values).length);
            offset += ((double[])ins.get((int)i).values).length;
        }
        return new DoubleFV(data);
    }

    public int hashCode() {
        return Arrays.hashCode((double[])this.values);
    }

    public boolean equals(Object obj) {
        return Arrays.equals((double[])this.values, (double[])((DoubleFV)obj).values);
    }

    public DoubleFV subvector(int beginIndex) {
        return new DoubleFV(Arrays.copyOfRange((double[])this.values, beginIndex, ((double[])this.values).length));
    }

    public DoubleFV subvector(int beginIndex, int endIndex) {
        return new DoubleFV(Arrays.copyOfRange((double[])this.values, beginIndex, endIndex));
    }
}

