/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.io.IOUtils;
import org.openimaj.io.WriteableBinary;

public class DiskCachingFeatureExtractor<FEATURE, OBJECT extends Identifiable>
implements FeatureExtractor<FEATURE, OBJECT> {
    private static Logger logger = Logger.getLogger(DiskCachingFeatureExtractor.class);
    private File cacheDir;
    private FeatureExtractor<FEATURE, OBJECT> extractor;
    private boolean force;

    public DiskCachingFeatureExtractor(File cacheDir, FeatureExtractor<FEATURE, OBJECT> extractor) {
        this(cacheDir, extractor, false);
    }

    public DiskCachingFeatureExtractor(File cacheDir, FeatureExtractor<FEATURE, OBJECT> extractor, boolean force) {
        this.cacheDir = cacheDir;
        this.extractor = extractor;
        this.force = force;
        this.cacheDir.mkdirs();
    }

    @Override
    public FEATURE extractFeature(OBJECT object) {
        File cachedFeature = new File(this.cacheDir, object.getID() + ".dat");
        cachedFeature.getParentFile().mkdirs();
        FEATURE feature = null;
        if (!this.force && cachedFeature.exists() && (feature = (FEATURE)this.load(cachedFeature)) != null) {
            return feature;
        }
        feature = this.extractor.extractFeature(object);
        try {
            return this.write(feature, cachedFeature);
        }
        catch (IOException e) {
            logger.warn((Object)("Caching of the feature for the " + object.getID() + " object was disabled"), (Throwable)e);
            return feature;
        }
    }

    private FEATURE write(FEATURE feature, File cachedFeature) throws IOException {
        if (feature instanceof WriteableBinary) {
            IOUtils.writeBinaryFull((File)cachedFeature, (WriteableBinary)((WriteableBinary)feature));
        } else {
            IOUtils.writeToFile(feature, (File)cachedFeature);
        }
        return feature;
    }

    private FEATURE load(File cachedFeature) {
        try {
            return (FEATURE)IOUtils.read((File)cachedFeature);
        }
        catch (Exception e) {
            try {
                return (FEATURE)IOUtils.readFromFile((File)cachedFeature);
            }
            catch (IOException e1) {
                logger.warn((Object)"Error reading from cache. Feature will be regenerated.");
                return null;
            }
        }
    }

    public String toString() {
        return this.extractor.toString();
    }
}

