/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.openimaj.audio.Audio;
import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.samples.SampleBufferFactory;
import org.openimaj.audio.timecode.AudioTimecode;

public class SampleChunk
extends Audio {
    private byte[] samples = new byte[1];
    private AudioTimecode startTimecode = new AudioTimecode(0L);

    public SampleChunk(AudioFormat af) {
        this(new byte[1], af);
    }

    public SampleChunk(byte[] samples, AudioFormat af) {
        this.setSamples(samples);
        this.format = af;
    }

    public SampleChunk(byte[] samples, AudioFormat af, AudioTimecode tc) {
        this.setSamples(samples);
        this.startTimecode = tc;
        this.format = af;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSamples(byte[] samples) {
        byte[] byArray = this.samples;
        synchronized (this.samples) {
            this.samples = samples;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public byte[] getSamples() {
        return this.samples;
    }

    public int getNumberOfSamples() {
        return this.samples.length / (this.format.getNBits() / 8);
    }

    public ByteBuffer getSamplesAsByteBuffer() {
        if (this.samples == null) {
            return null;
        }
        ByteOrder bo = null;
        bo = this.format.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        return ByteBuffer.wrap(this.samples).order(bo);
    }

    public SampleBuffer getSampleBuffer() {
        return SampleBufferFactory.createSampleBuffer(this, this.format);
    }

    public void setStartTimecode(AudioTimecode startTimecode) {
        this.startTimecode = startTimecode;
    }

    public AudioTimecode getStartTimecode() {
        return this.startTimecode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleChunk getSampleSlice(int start, int length) {
        int nBytesPerSample = this.format.getNBits() / 8;
        int startSampleByteIndex = start * nBytesPerSample;
        byte[] newSamples = new byte[length * nBytesPerSample];
        byte[] byArray = this.samples;
        synchronized (this.samples) {
            System.arraycopy(this.samples, startSampleByteIndex, newSamples, 0, length * nBytesPerSample);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            SampleChunk s = new SampleChunk(this.format);
            s.setSamples(newSamples);
            double samplesPerChannelPerMillisec = this.format.getSampleRateKHz();
            s.setStartTimecode(new AudioTimecode(this.getStartTimecode().getTimecodeInMilliseconds() + (long)((double)start / samplesPerChannelPerMillisec)));
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleChunk prepend(SampleChunk sample) {
        if (!sample.getFormat().equals(this.format)) {
            throw new IllegalArgumentException("Sample types are not equivalent");
        }
        byte[] x1 = sample.getSamplesAsByteBuffer().array();
        byte[] newSamples = new byte[this.samples.length + x1.length];
        System.arraycopy(x1, 0, newSamples, 0, x1.length);
        byte[] byArray = this.samples;
        synchronized (this.samples) {
            System.arraycopy(this.samples, 0, newSamples, x1.length, this.samples.length);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.samples = newSamples;
            this.setStartTimecode(sample.getStartTimecode().clone());
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleChunk append(SampleChunk sample) {
        if (!sample.getFormat().equals(this.format)) {
            throw new IllegalArgumentException("Sample types are not equivalent");
        }
        byte[] x1 = sample.getSamplesAsByteBuffer().array();
        byte[] newSamples = new byte[this.samples.length + x1.length];
        byte[] byArray = this.samples;
        synchronized (this.samples) {
            System.arraycopy(this.samples, 0, newSamples, 0, this.samples.length);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            System.arraycopy(x1, 0, newSamples, this.samples.length, x1.length);
            this.samples = newSamples;
            return this;
        }
    }

    public SampleChunk clone() {
        return new SampleChunk((byte[])this.samples.clone(), this.format.clone(), this.startTimecode.clone());
    }

    public void pad(int requiredSampleSetSize) {
        byte[] samples = new byte[requiredSampleSetSize * (this.format.getNBits() / 8)];
        System.arraycopy(this.samples, 0, samples, 0, this.samples.length);
        this.samples = samples;
    }
}

