/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.spectral;

import ch.akuhn.matrix.SparseMatrix;
import ch.akuhn.matrix.eigenvalues.Eigenvalues;
import org.apache.log4j.Logger;
import org.openimaj.ml.clustering.SimilarityClusterer;
import org.openimaj.ml.clustering.spectral.PreparedSpectralClustering;
import org.openimaj.ml.clustering.spectral.SpectralClusteringConf;
import org.openimaj.ml.clustering.spectral.SpectralIndexedClusters;

public class DoubleSpectralClustering
implements SimilarityClusterer<SpectralIndexedClusters> {
    static final Logger logger = Logger.getLogger(DoubleSpectralClustering.class);
    protected SpectralClusteringConf<double[]> conf;

    public DoubleSpectralClustering(SpectralClusteringConf<double[]> conf) {
        this.conf = conf;
    }

    protected DoubleSpectralClustering() {
    }

    @Override
    public SpectralIndexedClusters clusterSimilarity(SparseMatrix sim) {
        return this.cluster(sim);
    }

    @Override
    public SpectralIndexedClusters cluster(SparseMatrix data) {
        Eigenvalues eig = this.spectralCluster(data);
        PreparedSpectralClustering prep = new PreparedSpectralClustering(this.conf);
        return prep.cluster(eig);
    }

    protected Eigenvalues spectralCluster(SparseMatrix data) {
        SparseMatrix laplacian = this.laplacian(data);
        Eigenvalues eig = this.laplacianEigenVectors(laplacian);
        return eig;
    }

    protected Eigenvalues laplacianEigenVectors(SparseMatrix laplacian) {
        Eigenvalues eig = this.conf.eigenChooser.prepare(laplacian);
        eig.run();
        return eig;
    }

    protected SparseMatrix laplacian(SparseMatrix data) {
        return this.conf.laplacian.laplacian(data);
    }

    public int[][] performClustering(SparseMatrix data) {
        return this.cluster(data).clusters();
    }

    public String toString() {
        return String.format("%s: {Laplacian: %s, EigenChooser: %s, SpatialClusterer: %s}", this.simpleName(this), this.simpleName(this.conf.laplacian), this.simpleName(this.conf.eigenChooser), this.conf.internal);
    }

    private String simpleName(Object o) {
        return o.getClass().getSimpleName();
    }
}

