/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.spectral;

import ch.akuhn.matrix.SparseMatrix;
import ch.akuhn.matrix.eigenvalues.Eigenvalues;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.openimaj.io.IOUtils;
import org.openimaj.ml.clustering.spectral.DoubleSpectralClustering;
import org.openimaj.ml.clustering.spectral.SpectralClusteringConf;

public class CachedDoubleSpectralClustering
extends DoubleSpectralClustering {
    private static final Logger logger = Logger.getLogger(CachedDoubleSpectralClustering.class);
    private File cache;

    public CachedDoubleSpectralClustering(File cache, SpectralClusteringConf<double[]> conf) {
        super(conf);
        this.cache = cache;
    }

    @Override
    protected Eigenvalues spectralCluster(SparseMatrix data) {
        Eigenvalues eig = null;
        if (this.cache.exists()) {
            logger.debug((Object)"Loading eigenvectors from cache");
            try {
                eig = (Eigenvalues)IOUtils.readFromFile((File)this.cache);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug((Object)"Cache empty, recreating eigenvectors");
        SparseMatrix laplacian = this.laplacian(data);
        eig = this.laplacianEigenVectors(laplacian);
        try {
            logger.debug((Object)"Writing eigenvectors to cache");
            IOUtils.writeToFile((Object)eig, (File)this.cache);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return eig;
    }
}

