/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.random;

import java.util.Arrays;
import java.util.Random;
import org.openimaj.data.DataSource;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.LongCentroidsResult;
import org.openimaj.ml.clustering.SpatialClusterer;

public class RandomLongClusterer
implements SpatialClusterer<LongCentroidsResult, long[]> {
    protected int M;
    protected int K;
    protected Random random;
    protected long seed;

    public RandomLongClusterer(int M, int K) {
        this.M = M;
        this.K = K;
        this.random = new Random();
        this.seed = -1L;
    }

    public RandomLongClusterer(int M) {
        this(M, -1);
    }

    public void setSeed(long seed) {
        this.random = new Random();
        this.random.setSeed(seed);
        this.seed = seed;
    }

    public LongCentroidsResult cluster(long[][] data) {
        int nc = this.K;
        if (nc == -1) {
            nc = data.length;
        }
        LongCentroidsResult result = new LongCentroidsResult();
        result.centroids = new long[nc][];
        for (int i = 0; i < nc; ++i) {
            int dIndex = this.random.nextInt(data.length);
            result.centroids[i] = Arrays.copyOf(data[dIndex], data[dIndex].length);
        }
        return result;
    }

    public int[][] performClustering(long[][] data) {
        LongCentroidsResult res = this.cluster(data);
        return new IndexClusters(res.defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    @Override
    public LongCentroidsResult cluster(DataSource<long[]> data) {
        int nc = this.K;
        if (nc == -1) {
            nc = data.numRows();
        }
        LongCentroidsResult result = new LongCentroidsResult();
        result.centroids = new long[nc][this.M];
        long[][] dataRow = new long[1][];
        for (int i = 0; i < nc; ++i) {
            int dIndex = this.random.nextInt(data.numRows());
            dataRow[0] = result.centroids[i];
            data.getData(dIndex, dIndex + 1, (Object[])dataRow);
        }
        return result;
    }
}

