/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.openimaj.data.DataSource;
import org.openimaj.data.IntArrayBackedDataSource;
import org.openimaj.knn.IntNearestNeighbours;
import org.openimaj.knn.IntNearestNeighboursExact;
import org.openimaj.knn.IntNearestNeighboursProvider;
import org.openimaj.knn.NearestNeighboursFactory;
import org.openimaj.knn.approximate.IntNearestNeighboursKDTree;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.IntCentroidsResult;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactIntAssigner;
import org.openimaj.ml.clustering.assignment.hard.KDTreeIntEuclideanAssigner;
import org.openimaj.ml.clustering.kmeans.IntKMeansInit;
import org.openimaj.ml.clustering.kmeans.KMeansConfiguration;
import org.openimaj.util.pair.IntFloatPair;

public class IntKMeans
implements SpatialClusterer<IntCentroidsResult, int[]> {
    private IntKMeansInit init = new IntKMeansInit.RANDOM();
    private KMeansConfiguration<IntNearestNeighbours, int[]> conf;
    private Random rng = new Random();

    public IntKMeans(KMeansConfiguration<IntNearestNeighbours, int[]> conf) {
        this.conf = conf;
    }

    protected IntKMeans() {
        this(new KMeansConfiguration<IntNearestNeighbours, int[]>());
    }

    public IntKMeansInit getInit() {
        return this.init;
    }

    public void setInit(IntKMeansInit init) {
        this.init = init;
    }

    public void seed(long seed) {
        this.rng = seed < 0L ? new Random() : new Random(seed);
    }

    public IntCentroidsResult cluster(int[][] data) {
        IntArrayBackedDataSource ds = new IntArrayBackedDataSource(data, this.rng);
        try {
            Result result = this.cluster((DataSource<int[]>)ds, this.conf.K);
            result.nn = (IntNearestNeighbours)this.conf.factory.create((Object[])result.centroids);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int[][] performClustering(int[][] data) {
        IntCentroidsResult clusters = this.cluster(data);
        return new IndexClusters(clusters.defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    protected Result cluster(DataSource<int[]> data, int K) throws Exception {
        int D = data.numDimensions();
        Result result = new Result();
        result.centroids = new int[K][D];
        this.init.initKMeans(data, result.centroids);
        this.cluster(data, result);
        return result;
    }

    protected void cluster(DataSource<int[]> data, Result result) throws Exception {
        int[][] centroids = result.centroids;
        int K = centroids.length;
        int D = centroids[0].length;
        int N = data.numRows();
        float[][] centroids_accum = new float[K][D];
        int[] new_counts = new int[K];
        ExecutorService service = this.conf.threadpool;
        for (int i = 0; i < this.conf.niters; ++i) {
            for (int j = 0; j < K; ++j) {
                Arrays.fill(centroids_accum[j], 0.0f);
            }
            Arrays.fill(new_counts, 0);
            IntNearestNeighbours nno = (IntNearestNeighbours)this.conf.factory.create((Object[])centroids);
            ArrayList<CentroidAssignmentJob> jobs = new ArrayList<CentroidAssignmentJob>();
            for (int bl = 0; bl < N; bl += this.conf.blockSize) {
                int br = Math.min(bl + this.conf.blockSize, N);
                jobs.add(new CentroidAssignmentJob(data, bl, br, nno, centroids_accum, new_counts));
            }
            service.invokeAll(jobs);
            for (int k = 0; k < K; ++k) {
                if (new_counts[k] == 0) {
                    new_counts[k] = 1;
                    int[][] rnd = new int[][]{centroids[k]};
                    data.getRandomRows((Object[])rnd);
                    continue;
                }
                for (int d = 0; d < D; ++d) {
                    centroids[k][d] = (int)this.roundFloat((double)centroids_accum[k][d] / (double)new_counts[k]);
                }
            }
        }
    }

    protected float roundFloat(double value) {
        return (float)value;
    }

    protected double roundDouble(double value) {
        return value;
    }

    protected long roundLong(double value) {
        return Math.round(value);
    }

    protected int roundInt(double value) {
        return (int)Math.round(value);
    }

    @Override
    public IntCentroidsResult cluster(DataSource<int[]> ds) {
        try {
            Result result = this.cluster(ds, this.conf.K);
            result.nn = (IntNearestNeighbours)this.conf.factory.create((Object[])result.centroids);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public KMeansConfiguration<IntNearestNeighbours, int[]> getConfiguration() {
        return this.conf;
    }

    public void setConfiguration(KMeansConfiguration<IntNearestNeighbours, int[]> conf) {
        this.conf = conf;
    }

    public static IntKMeans createExact(int K) {
        KMeansConfiguration<IntNearestNeighbours, int[]> conf = new KMeansConfiguration<IntNearestNeighbours, int[]>(K, (NearestNeighboursFactory<IntNearestNeighbours, int[]>)new IntNearestNeighboursExact.Factory());
        return new IntKMeans(conf);
    }

    public static IntKMeans createExact(int K, int niters) {
        KMeansConfiguration<IntNearestNeighbours, int[]> conf = new KMeansConfiguration<IntNearestNeighbours, int[]>(K, (NearestNeighboursFactory<IntNearestNeighbours, int[]>)new IntNearestNeighboursExact.Factory(), niters);
        return new IntKMeans(conf);
    }

    public static IntKMeans createKDTreeEnsemble(int K) {
        KMeansConfiguration<IntNearestNeighbours, int[]> conf = new KMeansConfiguration<IntNearestNeighbours, int[]>(K, (NearestNeighboursFactory<IntNearestNeighbours, int[]>)new IntNearestNeighboursKDTree.Factory());
        return new IntKMeans(conf);
    }

    public String toString() {
        return String.format("%s: {K=%d, NN=%s}", this.getClass().getSimpleName(), this.conf.K, this.conf.getNearestNeighbourFactory().getClass().getSimpleName());
    }

    private static class Result
    extends IntCentroidsResult
    implements IntNearestNeighboursProvider {
        protected IntNearestNeighbours nn;

        private Result() {
        }

        @Override
        public HardAssigner<int[], float[], IntFloatPair> defaultHardAssigner() {
            if (this.nn instanceof IntNearestNeighboursExact) {
                return new ExactIntAssigner(this);
            }
            return new KDTreeIntEuclideanAssigner(this);
        }

        public IntNearestNeighbours getNearestNeighbours() {
            return this.nn;
        }
    }

    private static class CentroidAssignmentJob
    implements Callable<Boolean> {
        private final DataSource<int[]> ds;
        private final int startRow;
        private final int stopRow;
        private final IntNearestNeighbours nno;
        private final float[][] centroids_accum;
        private final int[] counts;

        public CentroidAssignmentJob(DataSource<int[]> ds, int startRow, int stopRow, IntNearestNeighbours nno, float[][] centroids_accum, int[] counts) {
            this.ds = ds;
            this.startRow = startRow;
            this.stopRow = stopRow;
            this.nno = nno;
            this.centroids_accum = centroids_accum;
            this.counts = counts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            try {
                int D = this.nno.numDimensions();
                int[][] points = new int[this.stopRow - this.startRow][D];
                this.ds.getData(this.startRow, this.stopRow, (Object[])points);
                int[] argmins = new int[points.length];
                float[] mins = new float[points.length];
                this.nno.searchNN((Object[])points, argmins, (Object)mins);
                float[][] fArray = this.centroids_accum;
                synchronized (this.centroids_accum) {
                    for (int i = 0; i < points.length; ++i) {
                        int k = argmins[i];
                        for (int d = 0; d < D; ++d) {
                            float[] fArray2 = this.centroids_accum[k];
                            int n = d;
                            fArray2[n] = fArray2[n] + (float)points[i][d];
                        }
                        int n = k;
                        this.counts[n] = this.counts[n] + 1;
                    }
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            {
                return true;
            }
        }
    }
}

