/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.kmeans;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.DataSource;
import org.openimaj.data.IndexedViewDataSource;
import org.openimaj.knn.DoubleNearestNeighbours;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.kmeans.DoubleKMeans;
import org.openimaj.ml.clustering.kmeans.HierarchicalDoubleKMeansResult;
import org.openimaj.ml.clustering.kmeans.KMeansConfiguration;
import org.openimaj.util.pair.IntDoublePair;

@Reference(type=ReferenceType.Inproceedings, author={"David. Nist'er", "Henrik. Stew'enius"}, title="Scalable Recognition with a Vocabulary Tree", year="2006", booktitle="CVPR", pages={"2161", "", "2168"}, customData={"Date-Added", "2010-11-12 09:33:18 +0000", "Date-Modified", "2010-11-22 15:11:22 +0000"})
public class HierarchicalDoubleKMeans
implements SpatialClusterer<HierarchicalDoubleKMeansResult, double[]> {
    int M;
    int K;
    KMeansConfiguration<DoubleNearestNeighbours, double[]> conf;
    int depth;

    public HierarchicalDoubleKMeans(KMeansConfiguration<DoubleNearestNeighbours, double[]> config, int M, int K, int depth) {
        this.conf = config;
        this.M = M;
        this.K = K;
        this.depth = depth;
    }

    public HierarchicalDoubleKMeans(int M, int K, int depth) {
        this(new KMeansConfiguration<DoubleNearestNeighbours, double[]>(), M, K, depth);
    }

    private double[][] extractSubset(double[][] data, int[] ids, int id) {
        int N = data.length;
        int M = data[0].length;
        int count = 0;
        for (int i = 0; i < N; ++i) {
            if (ids[i] != id) continue;
            ++count;
        }
        double[][] newData = new double[count][M];
        count = 0;
        for (int i = 0; i < N; ++i) {
            if (ids[i] != id) continue;
            System.arraycopy(data[i], 0, newData[count], 0, M);
            ++count;
        }
        return newData;
    }

    private HierarchicalDoubleKMeansResult.Node trainLevel(double[][] data, int K, int height) {
        HierarchicalDoubleKMeansResult.Node node = new HierarchicalDoubleKMeansResult.Node();
        node.children = height == 1 ? null : new HierarchicalDoubleKMeansResult.Node[K];
        DoubleKMeans kmeans = this.newDoubleKMeans(K);
        node.result = kmeans.cluster(data);
        HardAssigner<double[], double[], IntDoublePair> assigner = node.result.defaultHardAssigner();
        if (height > 1) {
            int[] ids = assigner.assign((DATATYPE[])data);
            for (int k = 0; k < K; ++k) {
                double[][] partition = this.extractSubset(data, ids, k);
                int partitionK = Math.min(K, partition.length);
                node.children[k] = this.trainLevel(partition, partitionK, height - 1);
            }
        }
        return node;
    }

    private HierarchicalDoubleKMeansResult.Node trainLevel(DataSource<double[]> data, int K, int height) {
        HierarchicalDoubleKMeansResult.Node node = new HierarchicalDoubleKMeansResult.Node();
        node.children = height == 1 ? null : new HierarchicalDoubleKMeansResult.Node[K];
        DoubleKMeans kmeans = this.newDoubleKMeans(K);
        node.result = kmeans.cluster((DataSource)data);
        HardAssigner<double[], double[], IntDoublePair> assigner = node.result.defaultHardAssigner();
        if (height > 1) {
            TIntObjectHashMap assignments = new TIntObjectHashMap();
            double[][] tmp = new double[1][this.M];
            for (int i = 0; i < data.numRows(); ++i) {
                data.getData(i, i + 1, (Object[])tmp);
                int asgn = assigner.assign(tmp[0]);
                TIntArrayList ids = (TIntArrayList)assignments.get(asgn);
                if (ids == null) {
                    ids = new TIntArrayList();
                    assignments.put(asgn, (Object)ids);
                }
                ids.add(i);
            }
            for (int k = 0; k < K; ++k) {
                int[] indexes = ((TIntArrayList)assignments.get(k)).toArray();
                IndexedViewDataSource partition = new IndexedViewDataSource(data, indexes);
                int partitionK = Math.min(K, partition.numRows());
                node.children[k] = this.trainLevel((DataSource<double[]>)partition, partitionK, height - 1);
            }
        }
        return node;
    }

    public HierarchicalDoubleKMeansResult cluster(double[][] data) {
        HierarchicalDoubleKMeansResult result = new HierarchicalDoubleKMeansResult();
        result.K = this.K;
        result.M = this.M;
        result.depth = this.depth;
        result.root = this.trainLevel(data, Math.min(this.K, data.length), this.depth);
        return result;
    }

    public int[][] performClustering(double[][] data) {
        HierarchicalDoubleKMeansResult clusters = this.cluster(data);
        return new IndexClusters(clusters.defaultHardAssigner().assign(data)).clusters();
    }

    @Override
    public HierarchicalDoubleKMeansResult cluster(DataSource<double[]> data) {
        HierarchicalDoubleKMeansResult result = new HierarchicalDoubleKMeansResult();
        result.K = this.K;
        result.M = this.M;
        result.depth = this.depth;
        result.root = this.trainLevel(data, Math.min(this.K, data.numRows()), this.depth);
        return result;
    }

    private DoubleKMeans newDoubleKMeans(int K) {
        Object newConf = this.conf.clone();
        ((KMeansConfiguration)newConf).setK(K);
        return new DoubleKMeans((KMeansConfiguration<DoubleNearestNeighbours, double[]>)newConf);
    }
}

