/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.openimaj.data.ByteArrayBackedDataSource;
import org.openimaj.data.DataSource;
import org.openimaj.knn.ByteNearestNeighbours;
import org.openimaj.knn.ByteNearestNeighboursExact;
import org.openimaj.knn.ByteNearestNeighboursProvider;
import org.openimaj.knn.NearestNeighboursFactory;
import org.openimaj.knn.approximate.ByteNearestNeighboursKDTree;
import org.openimaj.ml.clustering.ByteCentroidsResult;
import org.openimaj.ml.clustering.IndexClusters;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactByteAssigner;
import org.openimaj.ml.clustering.assignment.hard.KDTreeByteEuclideanAssigner;
import org.openimaj.ml.clustering.kmeans.ByteKMeansInit;
import org.openimaj.ml.clustering.kmeans.KMeansConfiguration;
import org.openimaj.util.pair.IntFloatPair;

public class ByteKMeans
implements SpatialClusterer<ByteCentroidsResult, byte[]> {
    private ByteKMeansInit init = new ByteKMeansInit.RANDOM();
    private KMeansConfiguration<ByteNearestNeighbours, byte[]> conf;
    private Random rng = new Random();

    public ByteKMeans(KMeansConfiguration<ByteNearestNeighbours, byte[]> conf) {
        this.conf = conf;
    }

    protected ByteKMeans() {
        this(new KMeansConfiguration<ByteNearestNeighbours, byte[]>());
    }

    public ByteKMeansInit getInit() {
        return this.init;
    }

    public void setInit(ByteKMeansInit init) {
        this.init = init;
    }

    public void seed(long seed) {
        this.rng = seed < 0L ? new Random() : new Random(seed);
    }

    public ByteCentroidsResult cluster(byte[][] data) {
        ByteArrayBackedDataSource ds = new ByteArrayBackedDataSource(data, this.rng);
        try {
            Result result = this.cluster((DataSource<byte[]>)ds, this.conf.K);
            result.nn = (ByteNearestNeighbours)this.conf.factory.create((Object[])result.centroids);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int[][] performClustering(byte[][] data) {
        ByteCentroidsResult clusters = this.cluster(data);
        return new IndexClusters(clusters.defaultHardAssigner().assign((DATATYPE[])data)).clusters();
    }

    protected Result cluster(DataSource<byte[]> data, int K) throws Exception {
        int D = data.numDimensions();
        Result result = new Result();
        result.centroids = new byte[K][D];
        this.init.initKMeans(data, result.centroids);
        this.cluster(data, result);
        return result;
    }

    protected void cluster(DataSource<byte[]> data, Result result) throws Exception {
        byte[][] centroids = result.centroids;
        int K = centroids.length;
        int D = centroids[0].length;
        int N = data.numRows();
        float[][] centroids_accum = new float[K][D];
        int[] new_counts = new int[K];
        ExecutorService service = this.conf.threadpool;
        for (int i = 0; i < this.conf.niters; ++i) {
            for (int j = 0; j < K; ++j) {
                Arrays.fill(centroids_accum[j], 0.0f);
            }
            Arrays.fill(new_counts, 0);
            ByteNearestNeighbours nno = (ByteNearestNeighbours)this.conf.factory.create((Object[])centroids);
            ArrayList<CentroidAssignmentJob> jobs = new ArrayList<CentroidAssignmentJob>();
            for (int bl = 0; bl < N; bl += this.conf.blockSize) {
                int br = Math.min(bl + this.conf.blockSize, N);
                jobs.add(new CentroidAssignmentJob(data, bl, br, nno, centroids_accum, new_counts));
            }
            service.invokeAll(jobs);
            for (int k = 0; k < K; ++k) {
                if (new_counts[k] == 0) {
                    new_counts[k] = 1;
                    byte[][] rnd = new byte[][]{centroids[k]};
                    data.getRandomRows((Object[])rnd);
                    continue;
                }
                for (int d = 0; d < D; ++d) {
                    centroids[k][d] = (byte)this.roundFloat((double)centroids_accum[k][d] / (double)new_counts[k]);
                }
            }
        }
    }

    protected float roundFloat(double value) {
        return (float)value;
    }

    protected double roundDouble(double value) {
        return value;
    }

    protected long roundLong(double value) {
        return Math.round(value);
    }

    protected int roundInt(double value) {
        return (int)Math.round(value);
    }

    @Override
    public ByteCentroidsResult cluster(DataSource<byte[]> ds) {
        try {
            Result result = this.cluster(ds, this.conf.K);
            result.nn = (ByteNearestNeighbours)this.conf.factory.create((Object[])result.centroids);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public KMeansConfiguration<ByteNearestNeighbours, byte[]> getConfiguration() {
        return this.conf;
    }

    public void setConfiguration(KMeansConfiguration<ByteNearestNeighbours, byte[]> conf) {
        this.conf = conf;
    }

    public static ByteKMeans createExact(int K) {
        KMeansConfiguration<ByteNearestNeighbours, byte[]> conf = new KMeansConfiguration<ByteNearestNeighbours, byte[]>(K, (NearestNeighboursFactory<ByteNearestNeighbours, byte[]>)new ByteNearestNeighboursExact.Factory());
        return new ByteKMeans(conf);
    }

    public static ByteKMeans createExact(int K, int niters) {
        KMeansConfiguration<ByteNearestNeighbours, byte[]> conf = new KMeansConfiguration<ByteNearestNeighbours, byte[]>(K, (NearestNeighboursFactory<ByteNearestNeighbours, byte[]>)new ByteNearestNeighboursExact.Factory(), niters);
        return new ByteKMeans(conf);
    }

    public static ByteKMeans createKDTreeEnsemble(int K) {
        KMeansConfiguration<ByteNearestNeighbours, byte[]> conf = new KMeansConfiguration<ByteNearestNeighbours, byte[]>(K, (NearestNeighboursFactory<ByteNearestNeighbours, byte[]>)new ByteNearestNeighboursKDTree.Factory());
        return new ByteKMeans(conf);
    }

    public String toString() {
        return String.format("%s: {K=%d, NN=%s}", this.getClass().getSimpleName(), this.conf.K, this.conf.getNearestNeighbourFactory().getClass().getSimpleName());
    }

    private static class Result
    extends ByteCentroidsResult
    implements ByteNearestNeighboursProvider {
        protected ByteNearestNeighbours nn;

        private Result() {
        }

        @Override
        public HardAssigner<byte[], float[], IntFloatPair> defaultHardAssigner() {
            if (this.nn instanceof ByteNearestNeighboursExact) {
                return new ExactByteAssigner(this);
            }
            return new KDTreeByteEuclideanAssigner(this);
        }

        public ByteNearestNeighbours getNearestNeighbours() {
            return this.nn;
        }
    }

    private static class CentroidAssignmentJob
    implements Callable<Boolean> {
        private final DataSource<byte[]> ds;
        private final int startRow;
        private final int stopRow;
        private final ByteNearestNeighbours nno;
        private final float[][] centroids_accum;
        private final int[] counts;

        public CentroidAssignmentJob(DataSource<byte[]> ds, int startRow, int stopRow, ByteNearestNeighbours nno, float[][] centroids_accum, int[] counts) {
            this.ds = ds;
            this.startRow = startRow;
            this.stopRow = stopRow;
            this.nno = nno;
            this.centroids_accum = centroids_accum;
            this.counts = counts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            try {
                int D = this.nno.numDimensions();
                byte[][] points = new byte[this.stopRow - this.startRow][D];
                this.ds.getData(this.startRow, this.stopRow, (Object[])points);
                int[] argmins = new int[points.length];
                float[] mins = new float[points.length];
                this.nno.searchNN((Object[])points, argmins, (Object)mins);
                float[][] fArray = this.centroids_accum;
                synchronized (this.centroids_accum) {
                    for (int i = 0; i < points.length; ++i) {
                        int k = argmins[i];
                        for (int d = 0; d < D; ++d) {
                            float[] fArray2 = this.centroids_accum[k];
                            int n = d;
                            fArray2[n] = fArray2[n] + (float)points[i][d];
                        }
                        int n = k;
                        this.counts[n] = this.counts[n] + 1;
                    }
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            {
                return true;
            }
        }
    }
}

