/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.soft;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.assignment.SoftAssigner;
import org.openimaj.ml.clustering.assignment.hard.ExactLongAssigner;
import org.openimaj.ml.clustering.kmeans.HierarchicalLongKMeansResult;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.IntDoublePair;

public class HierarchicalLongPathAssigner
implements SoftAssigner<long[], double[]> {
    protected HierarchicalLongKMeansResult result;
    protected Map<CentroidsProvider<long[]>, HardAssigner<long[], double[], IntDoublePair>> assigners;

    public HierarchicalLongPathAssigner(HierarchicalLongKMeansResult result) {
        this.result = result;
        this.assigners = new HashMap<CentroidsProvider<long[]>, HardAssigner<long[], double[], IntDoublePair>>();
    }

    public int[][] assign(long[][] data) {
        int[][] assignments = new int[data.length][this.result.getDepth()];
        block0: for (int i = 0; i < data.length; ++i) {
            HierarchicalLongKMeansResult.Node node = this.result.getRoot();
            int d = 0;
            while (node != null) {
                int best;
                ExactLongAssigner assigner = this.assigners.get(node.result);
                if (assigner == null) {
                    assigner = new ExactLongAssigner(node.result);
                    this.assigners.put(node.result, assigner);
                }
                assignments[i][d] = best = assigner.assign((long[])data[i]);
                ++d;
                if (node.children == null) continue block0;
                node = node.children[best];
            }
        }
        return assignments;
    }

    @Override
    public int[] assign(long[] data) {
        return this.assign(new long[][]{data})[0];
    }

    public void assignWeighted(long[][] data, int[][] assignments, double[][] weights) {
        int depth = this.result.getDepth();
        block0: for (int i = 0; i < data.length; ++i) {
            HierarchicalLongKMeansResult.Node node = this.result.getRoot();
            if (assignments[i].length != depth) {
                assignments[i] = new int[depth];
            }
            Arrays.fill((Object[])assignments, (Object)-1);
            if (weights[i].length != depth) {
                weights[i] = new double[depth];
            }
            int d = 0;
            while (node != null) {
                ExactLongAssigner assigner = this.assigners.get(node.result);
                if (assigner == null) {
                    assigner = new ExactLongAssigner(node.result);
                    this.assigners.put(node.result, assigner);
                }
                IntDoublePair best = assigner.assignDistance((long[])data[i]);
                assignments[i][d] = best.first;
                weights[i][d] = best.second;
                ++d;
                if (node.children == null) continue block0;
                node = node.children[best.first];
            }
        }
    }

    @Override
    public IndependentPair<int[], double[]> assignWeighted(long[] data) {
        int[][] assignments = new int[1][];
        double[][] weights = new double[1][];
        this.assignWeighted(new long[][]{data}, (int[][])assignments, weights);
        return new IndependentPair((Object)assignments[0], (Object)weights[0]);
    }

    @Override
    public int numDimensions() {
        return this.result.numDimensions();
    }
}

