/*
 * Decompiled with CFR 0.152.
 */
package org.lemurproject.ireval;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.lemurproject.ireval.RetrievalEvaluator;
import org.lemurproject.ireval.SetRetrievalComparator;
import org.lemurproject.ireval.SetRetrievalEvaluator;

public class IREval {
    public static TreeMap<String, ArrayList<RetrievalEvaluator.Judgment>> loadJudgments(String filename) throws IOException, FileNotFoundException {
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = null;
        TreeMap<String, ArrayList<RetrievalEvaluator.Judgment>> judgments = new TreeMap<String, ArrayList<RetrievalEvaluator.Judgment>>();
        String recentQuery = null;
        ArrayList<RetrievalEvaluator.Judgment> recentJudgments = null;
        while ((line = in.readLine()) != null) {
            String[] fields = line.split("\\s+");
            String number = fields[0];
            String unused = fields[1];
            String docno = fields[2];
            String judgment = fields[3];
            int jVal = 0;
            try {
                jVal = Integer.valueOf(judgment);
            }
            catch (NumberFormatException e) {
                jVal = (int)Math.round(Double.valueOf(judgment));
            }
            RetrievalEvaluator.Judgment j = new RetrievalEvaluator.Judgment(docno, jVal);
            if (recentQuery == null || !recentQuery.equals(number)) {
                if (!judgments.containsKey(number)) {
                    judgments.put(number, new ArrayList());
                }
                recentJudgments = judgments.get(number);
                recentQuery = number;
            }
            recentJudgments.add(j);
        }
        in.close();
        return judgments;
    }

    public static TreeMap<String, ArrayList<RetrievalEvaluator.Document>> loadRanking(String filename) throws IOException, FileNotFoundException {
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = null;
        TreeMap<String, ArrayList<RetrievalEvaluator.Document>> ranking = new TreeMap<String, ArrayList<RetrievalEvaluator.Document>>();
        ArrayList<RetrievalEvaluator.Document> recentRanking = null;
        String recentQuery = null;
        while ((line = in.readLine()) != null) {
            double scoreNumber;
            String[] fields = line.split("\\s+");
            String number = fields[0];
            String unused = fields[1];
            String docno = fields[2];
            String rank = fields[3];
            String score = fields[4];
            String runtag = fields[5];
            try {
                scoreNumber = Double.valueOf(score);
            }
            catch (NumberFormatException ex) {
                scoreNumber = 0.0;
            }
            RetrievalEvaluator.Document document = new RetrievalEvaluator.Document(docno, Integer.valueOf(rank), scoreNumber);
            if (recentQuery == null || !recentQuery.equals(number)) {
                if (!ranking.containsKey(number)) {
                    ranking.put(number, new ArrayList());
                }
                recentQuery = number;
                recentRanking = ranking.get(number);
            }
            recentRanking.add(document);
        }
        in.close();
        return ranking;
    }

    public static SetRetrievalEvaluator create(TreeMap<String, ArrayList<RetrievalEvaluator.Document>> allRankings, TreeMap<String, ArrayList<RetrievalEvaluator.Judgment>> allJudgments) {
        TreeMap<String, RetrievalEvaluator> evaluators = new TreeMap<String, RetrievalEvaluator>(new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                try {
                    Integer a1 = new Integer(a);
                    Integer b1 = new Integer(b);
                    return a1.compareTo(b1);
                }
                catch (NumberFormatException e) {
                    return a.compareTo(b);
                }
            }
        });
        for (String query : allRankings.keySet()) {
            ArrayList<RetrievalEvaluator.Judgment> judgments = allJudgments.get(query);
            ArrayList<RetrievalEvaluator.Document> ranking = allRankings.get(query);
            Collections.sort(ranking, new Comparator<RetrievalEvaluator.Document>(){

                @Override
                public int compare(RetrievalEvaluator.Document a, RetrievalEvaluator.Document b) {
                    if (a.score < b.score) {
                        return 1;
                    }
                    if (a.score == b.score) {
                        return 0;
                    }
                    return -1;
                }
            });
            int i = 1;
            for (RetrievalEvaluator.Document d : ranking) {
                d.rank = i++;
            }
            if (judgments == null || ranking == null) continue;
            RetrievalEvaluator evaluator = new RetrievalEvaluator(query, ranking, judgments);
            evaluators.put(query, evaluator);
        }
        return new SetRetrievalEvaluator(evaluators.values());
    }

    public static String singleQuery(String query, RetrievalEvaluator evaluator) {
        StringWriter s = new StringWriter();
        PrintWriter out = new PrintWriter(s);
        String formatString = "%2$-25s\t%1$5s\t";
        out.format(formatString + "%3$6d\n", query, "num_ret", evaluator.retrievedDocuments().size());
        out.format(formatString + "%3$6d\n", query, "num_rel", evaluator.relevantDocuments().size());
        out.format(formatString + "%3$6d\n", query, "num_rel_ret", evaluator.relevantRetrievedDocuments().size());
        out.format(formatString + "%3$6.4f\n", query, "map", evaluator.averagePrecision());
        out.format(formatString + "%3$6.4f\n", query, "ndcg", evaluator.normalizedDiscountedCumulativeGain());
        out.format(formatString + "%3$6.4f\n", query, "ndcg15", evaluator.normalizedDiscountedCumulativeGain(15));
        out.format(formatString + "%3$6.4f\n", query, "R-prec", evaluator.rPrecision());
        out.format(formatString + "%3$6.4f\n", query, "bpref", evaluator.binaryPreference());
        out.format(formatString + "%3$6.4f\n", query, "recip_rank", evaluator.reciprocalRank());
        int[] fixedPoints = RetrievalEvaluator.getFixedPoints();
        double[] vals = evaluator.precisionAtFixedPoints();
        for (int i = 0; i < fixedPoints.length; ++i) {
            int point = fixedPoints[i];
            out.format(formatString + "%3$6.4f\n", query, "P" + point, vals[i]);
        }
        double[] precs = evaluator.interpolatedPrecision();
        double prec = 0.0;
        for (int i = 0; i < precs.length; ++i) {
            out.format("ircl_prn.%3$3.2f%2$-18s\t%1$5s\t%4$6.4f\n", query, " ", prec, precs[i]);
            prec += 0.1;
        }
        out.format("\n", new Object[0]);
        return s.toString();
    }

    public static String singleEvaluation(SetRetrievalEvaluator setEvaluator, boolean showIndividual) {
        StringWriter s = new StringWriter();
        PrintWriter out = new PrintWriter(s);
        String formatString = "%2$-25s\t%1$5s\t";
        if (showIndividual) {
            for (RetrievalEvaluator evaluator : setEvaluator.getEvaluators()) {
                String query = evaluator.queryName();
                out.print(IREval.singleQuery(query, evaluator));
            }
        }
        out.format(formatString + "%3$6d\n", "all", "num_q", setEvaluator.getEvaluators().size());
        out.format(formatString + "%3$6d\n", "all", "num_ret", setEvaluator.numberRetrieved());
        out.format(formatString + "%3$6d\n", "all", "num_rel", setEvaluator.numberRelevant());
        out.format(formatString + "%3$6d\n", "all", "num_rel_ret", setEvaluator.numberRelevantRetrieved());
        out.format(formatString + "%3$6.4f\n", "all", "map", setEvaluator.meanAveragePrecision());
        out.format(formatString + "%3$6.4f\n", "all", "gm_ap", setEvaluator.geometricMeanAveragePrecision());
        out.format(formatString + "%3$6.4f\n", "all", "ndcg", setEvaluator.meanNormalizedDiscountedCumulativeGain());
        out.format(formatString + "%3$6.4f\n", "all", "R-prec", setEvaluator.meanRPrecision());
        out.format(formatString + "%3$6.4f\n", "all", "bpref", setEvaluator.meanBinaryPreference());
        out.format(formatString + "%3$6.4f\n", "all", "recip_rank", setEvaluator.meanReciprocalRank());
        int[] fixedPoints = SetRetrievalEvaluator.getFixedPoints();
        double[] precs = setEvaluator.precisionAtFixedPoints();
        for (int i = 0; i < fixedPoints.length; ++i) {
            int point = fixedPoints[i];
            out.format(formatString + "%3$6.4f\n", "all", "P" + point, precs[i]);
        }
        double prec = 0.0;
        precs = setEvaluator.interpolatedPrecision();
        for (int i = 0; i < precs.length; ++i) {
            out.format("ircl_prn.%3$3.2f%2$-18s\t%1$5s\t%4$6.4f\n", "all", " ", prec, precs[i]);
            prec += 0.1;
        }
        out.format("\n", new Object[0]);
        return s.toString();
    }

    public static String comparisonEvaluation(SetRetrievalEvaluator baseline, SetRetrievalEvaluator treatment, String baselineName, String treatmentName) {
        StringWriter s = new StringWriter();
        PrintWriter out = new PrintWriter(s);
        String[] metrics = new String[]{"averagePrecision", "rPrecision", "ndcg", "bpref", "P5", "P10", "P20"};
        String formatString = "%1$-20s%2$-30s%3$6.4f\n";
        String integerFormatString = "%1$-20s%2$-30s%3$6d\n";
        out.println("Comparing baseline: " + baselineName + " to treatment: " + treatmentName + "\n");
        if (treatment == null) {
            return "NOPE";
        }
        for (String metric : metrics) {
            Map<String, Double> baselineMetric = baseline.evaluateAll(metric);
            Map<String, Double> treatmentMetric = treatment.evaluateAll(metric);
            SetRetrievalComparator comparator = new SetRetrievalComparator(baselineMetric, treatmentMetric);
            out.format(formatString, metric, baselineName, comparator.meanBaselineMetric());
            out.format(formatString, metric, treatmentName, comparator.meanTreatmentMetric());
            out.format(integerFormatString, metric, "basebetter", comparator.countBaselineBetter());
            out.format(integerFormatString, metric, "treatbetter", comparator.countTreatmentBetter());
            out.format(integerFormatString, metric, "equal", comparator.countEqual());
            out.format(formatString, metric, "ttest", comparator.pairedTTest());
            out.format(formatString, metric, "randomized", comparator.randomizedTest());
            out.format(formatString, metric, "signtest", comparator.signTest());
        }
        return s.toString();
    }

    public static void usage() {
        System.err.println("ireval: ");
        System.err.println("   There are two ways to use this program.  First, you can evaluate a single ranking: ");
        System.err.println("      java -jar ireval.jar TREC-Ranking-File TREC-Judgments-File");
        System.err.println("   or, you can use it to compare two rankings with statistical tests: ");
        System.err.println("      java -jar ireval.jar TREC-Baseline-Ranking-File TREC-Improved-Ranking-File TREC-Judgments-File");
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        try {
            if (args.length == 3) {
                TreeMap<String, ArrayList<RetrievalEvaluator.Document>> baselineRanking = IREval.loadRanking(args[0]);
                TreeMap<String, ArrayList<RetrievalEvaluator.Document>> treatmentRanking = IREval.loadRanking(args[1]);
                TreeMap<String, ArrayList<RetrievalEvaluator.Judgment>> judgments = IREval.loadJudgments(args[2]);
                SetRetrievalEvaluator baseline = IREval.create(baselineRanking, judgments);
                SetRetrievalEvaluator treatment = IREval.create(treatmentRanking, judgments);
                System.out.println(IREval.comparisonEvaluation(baseline, treatment, "baseline", "treatment"));
            } else if (args.length == 2) {
                TreeMap<String, ArrayList<RetrievalEvaluator.Document>> ranking = IREval.loadRanking(args[0]);
                TreeMap<String, ArrayList<RetrievalEvaluator.Judgment>> judgments = IREval.loadJudgments(args[1]);
                SetRetrievalEvaluator setEvaluator = IREval.create(ranking, judgments);
                System.out.println(IREval.singleEvaluation(setEvaluator, true));
            } else {
                IREval.usage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            IREval.usage();
        }
    }
}

