/*
 * Decompiled with CFR 0.152.
 */
package com.jsaragih;

import Jama.Matrix;
import com.jsaragih.Tracker;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Scanner;
import org.openimaj.image.FImage;

public class IO {
    public static Matrix readMat(Scanner s) {
        s.useLocale(Locale.UK);
        int r = s.nextInt();
        int c = s.nextInt();
        s.nextInt();
        Matrix M = new Matrix(r, c);
        double[][] Mv = M.getArray();
        for (int rr = 0; rr < r; ++rr) {
            for (int cc = 0; cc < c; ++cc) {
                Mv[rr][cc] = s.nextDouble();
            }
        }
        return M;
    }

    static void writeMat(BufferedWriter s, Matrix M) throws IOException {
        int r = M.getRowDimension();
        int c = M.getColumnDimension();
        s.write(r + " " + c + " 0");
        double[][] Mv = M.getArray();
        for (int rr = 0; rr < r; ++rr) {
            for (int cc = 0; cc < c; ++cc) {
                s.write(Mv[rr][cc] + " ");
            }
        }
    }

    static void writeImg(BufferedWriter s, FImage img) throws IOException {
        int r = img.height;
        int c = img.width;
        s.write(r + " " + c + " 0");
        float[][] Mv = img.pixels;
        for (int rr = 0; rr < r; ++rr) {
            for (int cc = 0; cc < c; ++cc) {
                s.write(Mv[rr][cc] + " ");
            }
        }
    }

    static FImage readImg(Scanner s) {
        s.useLocale(Locale.UK);
        int r = s.nextInt();
        int c = s.nextInt();
        s.nextInt();
        FImage M = new FImage(c, r);
        float[][] Mv = M.pixels;
        for (int rr = 0; rr < r; ++rr) {
            for (int cc = 0; cc < c; ++cc) {
                Mv[rr][cc] = s.nextFloat();
            }
        }
        return M;
    }

    static void writeIntArray(BufferedWriter s, int[][] arr) throws IOException {
        int r = arr.length;
        int c = arr[0].length;
        s.write(r + " " + c + " 0");
        for (int rr = 0; rr < r; ++rr) {
            for (int cc = 0; cc < c; ++cc) {
                s.write(arr[rr][cc] + " ");
            }
        }
    }

    static int[][] readIntArray(Scanner s) {
        s.useLocale(Locale.UK);
        int r = s.nextInt();
        int c = s.nextInt();
        s.nextInt();
        int[][] M = new int[r][c];
        for (int rr = 0; rr < r; ++rr) {
            for (int cc = 0; cc < c; ++cc) {
                M[rr][cc] = s.nextInt();
            }
        }
        return M;
    }

    static int[][] loadCon(String fname) throws FileNotFoundException {
        return IO.loadCon(new FileInputStream(fname));
    }

    public static int[][] loadCon(InputStream in) {
        String c;
        String str;
        Scanner s = new Scanner(in);
        s.useLocale(Locale.UK);
        while (!"n_connections:".equals(str = s.next())) {
        }
        int n = s.nextInt();
        int[][] con = new int[2][n];
        while (!(c = s.next()).equals("{")) {
        }
        for (int i = 0; i < n; ++i) {
            con[0][i] = s.nextInt();
            con[1][i] = s.nextInt();
        }
        s.close();
        return con;
    }

    static int[][] loadTri(String fname) throws FileNotFoundException {
        return IO.loadTri(new FileInputStream(fname));
    }

    public static int[][] loadTri(InputStream in) {
        String c;
        String str;
        Scanner s = new Scanner(in);
        s.useLocale(Locale.UK);
        while (!"n_tri:".equals(str = s.next())) {
        }
        int n = s.nextInt();
        int[][] tri = new int[n][3];
        while (!(c = s.next()).equals("{")) {
        }
        for (int i = 0; i < n; ++i) {
            tri[i][0] = s.nextInt();
            tri[i][1] = s.nextInt();
            tri[i][2] = s.nextInt();
        }
        s.close();
        return tri;
    }

    static FImage readImgByte(Scanner s) {
        s.useLocale(Locale.UK);
        int r = s.nextInt();
        int c = s.nextInt();
        s.nextInt();
        FImage M = new FImage(c, r);
        float[][] Mv = M.pixels;
        for (int rr = 0; rr < r; ++rr) {
            for (int cc = 0; cc < c; ++cc) {
                Mv[rr][cc] = s.next("[^ ]").codePointAt(0);
            }
        }
        return M;
    }

    static {
        Tracker.init();
    }

    public static enum Types {
        PDM,
        PAW,
        PATCH,
        MPATCH,
        CLM,
        FDET,
        FCHECK,
        MFCHECK,
        TRACKER;

    }
}

