/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.core;

import java.util.Locale;

public final class DataProviderID
implements Comparable<DataProviderID> {
    private final boolean isInternal;
    private final String name;
    private final String normalizedName;

    public static DataProviderID newInternalID(String name) {
        return new DataProviderID(name, true);
    }

    public static DataProviderID newUserID(String name) {
        return new DataProviderID(name, false);
    }

    private DataProviderID(String name, boolean isInternal) {
        this.name = name;
        this.normalizedName = name.trim().toLowerCase(Locale.ENGLISH);
        this.isInternal = isInternal;
    }

    @Override
    public int compareTo(DataProviderID o) {
        if (this.isInternal != o.isInternal) {
            return this.isInternal ? 1 : -1;
        }
        return this.normalizedName.compareTo(o.normalizedName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DataProviderID) {
            DataProviderID other = (DataProviderID)obj;
            return this.isInternal == other.isInternal && this.normalizedName.equals(other.normalizedName);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.normalizedName.hashCode();
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public String toString() {
        if (this.isInternal) {
            return "__" + this.name;
        }
        return this.name;
    }
}

