/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.core;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.util.Reject;

public final class DataProviderEvent {
    private final LocalizableMessage reason;
    private final Set<Type> types;

    public DataProviderEvent(LocalizableMessage reason, Set<Type> types) {
        Reject.ifNull((Object[])new Object[]{reason, types});
        Reject.ifTrue((boolean)types.isEmpty());
        this.reason = reason;
        EnumSet<Type> tmp = EnumSet.noneOf(Type.class);
        tmp.addAll(types);
        this.types = Collections.unmodifiableSet(tmp);
    }

    public Set<Type> getEventTypes() {
        return this.types;
    }

    public LocalizableMessage getReason() {
        return this.reason;
    }

    public String toString() {
        return this.reason.toString();
    }

    public static enum Type {
        ACCESS_MODE,
        BASE_DNS,
        SUPPORTED_CONTROLS,
        SUPPORTED_FEATURES;

    }
}

