/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.codahale.metrics.Metric;
import com.codahale.metrics.RatioGauge;
import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.MultiColumnPrinter;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.tools.DataSource;
import com.forgerock.opendj.ldap.tools.LDAPToolArgumentParser;
import com.forgerock.opendj.ldap.tools.PerformanceRunner;
import com.forgerock.opendj.ldap.tools.PerformanceRunnerOptions;
import com.forgerock.opendj.ldap.tools.StatsThread;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;

public final class SearchRate
extends ConsoleApplication {
    private BooleanArgument verbose;
    private BooleanArgument scriptFriendly;
    private StatsThread.IntervalCounter entryCount = StatsThread.newIntervalCounter();

    public static void main(String[] args) {
        int retCode = new SearchRate().run(args);
        System.exit(com.forgerock.opendj.cli.Utils.filterExitCode((int)retCode));
    }

    private SearchRate() {
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isScriptFriendly() {
        return this.scriptFriendly.isPresent();
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    private int run(String[] args) {
        ConnectionFactory connectionFactory;
        MultiChoiceArgument dereferencePolicy;
        MultiChoiceArgument searchScope;
        StringArgument baseDN;
        SearchPerformanceRunner runner;
        ConnectionFactoryProvider connectionFactoryProvider;
        LocalizableMessage toolDescription = ToolsMessages.INFO_SEARCHRATE_TOOL_DESCRIPTION.get();
        LDAPToolArgumentParser argParser = LDAPToolArgumentParser.builder(SearchRate.class.getName()).toolDescription(toolDescription).trailingArgumentsUnbounded(1, "[filter format string] [attributes ...]").build();
        argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_SEARCHRATE.get());
        argParser.setDocToolDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_RATE_TOOLS.get());
        try {
            Utils.setDefaultPerfToolProperties();
            connectionFactoryProvider = new ConnectionFactoryProvider((ArgumentParser)argParser, (ConsoleApplication)this);
            runner = new SearchPerformanceRunner(new PerformanceRunnerOptions(argParser, this));
            StringArgument propertiesFileArgument = CommonArguments.propertiesFileArgument();
            argParser.addArgument((Argument)propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = CommonArguments.noPropertiesFileArgument();
            argParser.addArgument((Argument)noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            BooleanArgument showUsage = CommonArguments.showUsageArgument();
            argParser.addArgument((Argument)showUsage);
            argParser.setUsageArgument((Argument)showUsage, this.getOutputStream());
            baseDN = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"baseDN").shortIdentifier(Character.valueOf('b'))).description(ToolsMessages.INFO_SEARCHRATE_TOOL_DESCRIPTION_BASEDN.get())).required()).valuePlaceholder(ToolsMessages.INFO_BASEDN_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            searchScope = CommonArguments.searchScopeArgument();
            argParser.addArgument((Argument)searchScope);
            dereferencePolicy = (MultiChoiceArgument)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)MultiChoiceArgument.builder((String)"dereferencePolicy").shortIdentifier(Character.valueOf('a'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_DEREFERENCE_POLICY.get())).allowedValues((Collection)DereferenceAliasesPolicy.values()).defaultValue((Object)DereferenceAliasesPolicy.NEVER)).valuePlaceholder(ToolsMessages.INFO_DEREFERENCE_POLICE_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            this.verbose = CommonArguments.verboseArgument();
            argParser.addArgument((Argument)this.verbose);
            this.scriptFriendly = CommonArguments.scriptFriendlySdkArgument();
            argParser.addArgument((Argument)this.scriptFriendly);
        }
        catch (ArgumentException ae) {
            LocalizableMessage message = ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage());
            this.errPrintln(message);
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            argParser.parseArguments(args);
            if (argParser.usageOrVersionDisplayed()) {
                return 0;
            }
            connectionFactory = connectionFactoryProvider.getAuthenticatedConnectionFactory();
            runner.setBindRequest(connectionFactoryProvider.getBindRequest());
            runner.validate();
        }
        catch (ArgumentException ae) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        LinkedList attributes = new LinkedList();
        ArrayList filterAndAttributeStrings = argParser.getTrailingArguments();
        if (!filterAndAttributeStrings.isEmpty()) {
            runner.filter = (String)filterAndAttributeStrings.remove(0);
            attributes.addAll(filterAndAttributeStrings);
        }
        SearchPerformanceRunner.access$402(runner, attributes.toArray(new String[attributes.size()]));
        runner.baseDN = baseDN.getValue();
        try {
            runner.scope = (SearchScope)searchScope.getTypedValue();
            runner.dereferencesAliasesPolicy = (DereferenceAliasesPolicy)dereferencePolicy.getTypedValue();
        }
        catch (ArgumentException ex1) {
            this.errPrintln(ex1.getMessageObject());
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            Object[] data = DataSource.generateData(runner.getDataSources(), null);
            String.format(runner.filter, data);
            String.format(runner.baseDN, data);
        }
        catch (Exception ex1) {
            this.errPrintln(LocalizableMessage.raw((CharSequence)("Error formatting filter or base DN: " + ex1), (Object[])new Object[0]));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        return runner.run(connectionFactory);
    }

    private final class SearchPerformanceRunner
    extends PerformanceRunner {
        private String filter;
        private String baseDN;
        private SearchScope scope;
        private DereferenceAliasesPolicy dereferencesAliasesPolicy;
        private String[] attributes;

        private SearchPerformanceRunner(PerformanceRunnerOptions options) throws ArgumentException {
            super(options);
        }

        @Override
        PerformanceRunner.WorkerThread newWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
            return new SearchWorkerThread(connection, connectionFactory);
        }

        @Override
        StatsThread newStatsThread(PerformanceRunner performanceRunner, ConsoleApplication app) {
            return new SearchStatsThread(performanceRunner, app);
        }

        static /* synthetic */ String[] access$402(SearchPerformanceRunner x0, String[] x1) {
            x0.attributes = x1;
            return x1;
        }

        private final class SearchWorkerThread
        extends PerformanceRunner.WorkerThread {
            private SearchRequest sr;
            private Object[] data;

            private SearchWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
                super(SearchPerformanceRunner.this, connection, connectionFactory);
            }

            @Override
            public Promise<?, LdapException> performOperation(Connection connection, DataSource[] dataSources, long currentTimeNs) {
                if (this.sr == null) {
                    if (dataSources == null) {
                        this.sr = Requests.newSearchRequest((String)SearchPerformanceRunner.this.baseDN, (SearchScope)SearchPerformanceRunner.this.scope, (String)SearchPerformanceRunner.this.filter, (String[])SearchPerformanceRunner.this.attributes);
                    } else {
                        this.data = DataSource.generateData(dataSources, this.data);
                        this.sr = Requests.newSearchRequest((String)String.format(SearchPerformanceRunner.this.baseDN, this.data), (SearchScope)SearchPerformanceRunner.this.scope, (String)String.format(SearchPerformanceRunner.this.filter, this.data), (String[])SearchPerformanceRunner.this.attributes);
                    }
                    this.sr.setDereferenceAliasesPolicy(SearchPerformanceRunner.this.dereferencesAliasesPolicy);
                } else if (dataSources != null) {
                    this.data = DataSource.generateData(dataSources, this.data);
                    this.sr.setFilter(String.format(SearchPerformanceRunner.this.filter, this.data));
                    this.sr.setName(String.format(SearchPerformanceRunner.this.baseDN, this.data));
                }
                SearchStatsHandler handler = new SearchStatsHandler(currentTimeNs);
                this.incrementIterationCount();
                return connection.searchAsync(this.sr, (SearchResultHandler)handler).thenOnResult((ResultHandler)handler).thenOnException((ExceptionHandler)handler);
            }
        }

        private final class SearchStatsThread
        extends StatsThread {
            private static final int ENTRIES_PER_SEARCH_COLUMN_WIDTH = 5;
            private static final String ENTRIES_PER_SEARCH = "org.forgerock.opendj.entries_per_search";

            private SearchStatsThread(PerformanceRunner perfRunner, ConsoleApplication app) {
                super(perfRunner, app);
            }

            @Override
            void resetAdditionalStats() {
                SearchRate.this.entryCount = SearchStatsThread.newIntervalCounter();
            }

            @Override
            List<MultiColumnPrinter.Column> registerAdditionalColumns() {
                this.registry.register(ENTRIES_PER_SEARCH, (Metric)new RatioGauge(){

                    protected RatioGauge.Ratio getRatio() {
                        return RatioGauge.Ratio.of((double)SearchRate.this.entryCount.refreshIntervalCount(), (double)SearchStatsThread.this.successCount.getLastIntervalCount());
                    }
                });
                return Collections.singletonList(MultiColumnPrinter.column((String)ENTRIES_PER_SEARCH, (String)"Entries/Srch", (int)5, (int)1));
            }
        }

        private final class SearchStatsHandler
        extends PerformanceRunner.UpdateStatsResultHandler<Result>
        implements SearchResultHandler {
            private SearchStatsHandler(long startTime) {
                super(SearchPerformanceRunner.this, startTime);
            }

            public boolean handleEntry(SearchResultEntry entry) {
                SearchRate.this.entryCount.inc();
                return true;
            }

            public boolean handleReference(SearchResultReference reference) {
                return true;
            }
        }
    }
}

