/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.ldap.tools.LDAPToolException;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import java.io.PrintStream;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.BindRequest;

final class LDAPToolArgumentParser
extends ArgumentParser {
    private static final boolean WITH_BIND_REQUEST = true;
    private static final boolean WITHOUT_BIND_REQUEST = false;
    private ConnectionFactory connectionFactory;
    private BindRequest bindRequest;
    private final boolean needAuthenticatedCF;

    static Builder builder(String mainClassName) {
        return new Builder(mainClassName);
    }

    ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    BindRequest getBindRequest() {
        return this.bindRequest;
    }

    private LDAPToolArgumentParser(String mainClassName, LocalizableMessage toolDescription, boolean longArgumentsCaseSensitive, boolean allowsTrailingArguments, int minTrailingArguments, int maxTrailingArguments, String trailingArgsDisplayName, boolean needAuthenticatedCF) {
        super(mainClassName, toolDescription, longArgumentsCaseSensitive, allowsTrailingArguments, minTrailingArguments, maxTrailingArguments, trailingArgsDisplayName);
        this.needAuthenticatedCF = needAuthenticatedCF;
    }

    void parseArguments(String[] args, PrintStream stream, ConnectionFactoryProvider provider) throws LDAPToolException {
        this.parseLdapToolArgument(args, provider, stream, true);
    }

    void parseArgumentsNoBindRequest(String[] args, PrintStream stream, ConnectionFactoryProvider provider) throws LDAPToolException {
        this.parseLdapToolArgument(args, provider, stream, false);
    }

    private void parseLdapToolArgument(String[] args, ConnectionFactoryProvider provider, PrintStream stream, boolean withBindRequest) throws LDAPToolException {
        try {
            this.parseArguments(args);
            if (this.usageOrVersionDisplayed()) {
                return;
            }
            ConnectionFactory connectionFactory = this.connectionFactory = this.needAuthenticatedCF ? provider.getAuthenticatedConnectionFactory() : provider.getUnauthenticatedConnectionFactory();
            if (withBindRequest) {
                this.bindRequest = provider.getBindRequest();
            }
        }
        catch (ArgumentException ae) {
            this.displayMessageAndUsageReference(stream, ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            throw LDAPToolException.newToolExceptionAlreadyPrinted((Exception)((Object)ae), ResultCode.CLIENT_SIDE_PARAM_ERROR);
        }
    }

    static final class Builder {
        private final String mainClassName;
        private LocalizableMessage toolDescription;
        private boolean allowTrailingArgs;
        private int minTrailingArguments;
        private int maxTrailingArguments;
        private String trailingArgsDisplayName;
        private boolean needAuthenticatedConnectionFactory;

        Builder(String mainClassName) {
            this.mainClassName = mainClassName;
        }

        Builder toolDescription(LocalizableMessage toolDescription) {
            this.toolDescription = toolDescription;
            return this;
        }

        Builder trailingArguments(String displayNames) {
            return this.trailingArguments(0, 0, displayNames);
        }

        Builder trailingArguments(int nbTrailingArguments, String displayNames) {
            return this.trailingArguments(nbTrailingArguments, nbTrailingArguments, displayNames);
        }

        Builder trailingArgumentsUnbounded(int min, String displayNames) {
            return this.trailingArguments(min, 0, displayNames);
        }

        Builder trailingArguments(int min, int max, String displayNames) {
            this.minTrailingArguments = min;
            this.maxTrailingArguments = max;
            this.trailingArgsDisplayName = displayNames;
            this.allowTrailingArgs = true;
            return this;
        }

        Builder needAuthenticatedConnectionFactory() {
            this.needAuthenticatedConnectionFactory = true;
            return this;
        }

        LDAPToolArgumentParser build() {
            return new LDAPToolArgumentParser(this.mainClassName, this.toolDescription, false, this.allowTrailingArgs, this.minTrailingArguments, this.maxTrailingArguments, this.trailingArgsDisplayName, this.needAuthenticatedConnectionFactory);
        }
    }
}

