/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentConstants;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.controls.AccountUsabilityResponseControl;
import com.forgerock.opendj.ldap.tools.LDAPToolArgumentParser;
import com.forgerock.opendj.ldap.tools.LDAPToolException;
import com.forgerock.opendj.ldap.tools.ToolConsoleApplication;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import com.forgerock.opendj.util.StaticUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.EntryChangeNotificationResponseControl;
import org.forgerock.opendj.ldap.controls.GetEffectiveRightsRequestControl;
import org.forgerock.opendj.ldap.controls.MatchedValuesRequestControl;
import org.forgerock.opendj.ldap.controls.PersistentSearchChangeType;
import org.forgerock.opendj.ldap.controls.PersistentSearchRequestControl;
import org.forgerock.opendj.ldap.controls.ProxiedAuthV2RequestControl;
import org.forgerock.opendj.ldap.controls.ServerSideSortRequestControl;
import org.forgerock.opendj.ldap.controls.ServerSideSortResponseControl;
import org.forgerock.opendj.ldap.controls.SimplePagedResultsControl;
import org.forgerock.opendj.ldap.controls.SubentriesRequestControl;
import org.forgerock.opendj.ldap.controls.VirtualListViewRequestControl;
import org.forgerock.opendj.ldap.controls.VirtualListViewResponseControl;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LDIFEntryWriter;
import org.forgerock.util.annotations.VisibleForTesting;

public final class LDAPSearch
extends ToolConsoleApplication {
    private BooleanArgument verbose;
    private EntryWriter ldifWriter;

    public static void main(String[] args) {
        Utils.runToolAndExit(new LDAPSearch(System.out, System.err), args);
    }

    public static int run(PrintStream out, PrintStream err, String ... args) {
        return Utils.runTool(new LDAPSearch(out, err), args);
    }

    @VisibleForTesting
    LDAPSearch(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    @Override
    int run(String ... args) throws LDAPToolException {
        try {
            return this.runLdapSearch(args);
        }
        catch (ArgumentException e) {
            throw LDAPToolException.newToolParamException((Exception)((Object)e), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)e.getMessageObject()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    int runLdapSearch(String[] args) throws LDAPToolException, ArgumentException {
        int n;
        Object object;
        Connection connection;
        block53: {
            block54: {
                Result result;
                boolean hasRemainingPages;
                SearchRequest searchRequest;
                BooleanArgument noop;
                BooleanArgument subEntriesArgument;
                BooleanArgument countEntries;
                IntegerArgument wrapColumn;
                IntegerArgument timeLimit;
                IntegerArgument sizeLimit;
                BooleanArgument typesOnly;
                MultiChoiceArgument dereferencePolicy;
                StringArgument effectiveRightsAttrs;
                StringArgument effectiveRightsUser;
                StringArgument controlStr;
                StringArgument vlvDescriptor;
                StringArgument sortOrder;
                StringArgument matchedValuesFilter;
                StringArgument assertionFilter;
                IntegerArgument simplePageSize;
                StringArgument pSearchInfo;
                StringArgument proxyAuthzID;
                MultiChoiceArgument searchScope;
                StringArgument baseDN;
                ConnectionFactoryProvider connectionFactoryProvider;
                LocalizableMessage toolDescription = ToolsMessages.INFO_LDAPSEARCH_TOOL_DESCRIPTION.get();
                LDAPToolArgumentParser argParser = LDAPToolArgumentParser.builder(LDAPSearch.class.getName()).toolDescription(toolDescription).trailingArgumentsUnbounded(1, "filter [attributes ...]").build();
                argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
                argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDAPSEARCH.get());
                try {
                    connectionFactoryProvider = new ConnectionFactoryProvider((ArgumentParser)argParser, (ConsoleApplication)this);
                    StringArgument propertiesFileArgument = CommonArguments.propertiesFileArgument();
                    argParser.addArgument((Argument)propertiesFileArgument);
                    argParser.setFilePropertiesArgument(propertiesFileArgument);
                    BooleanArgument noPropertiesFileArgument = CommonArguments.noPropertiesFileArgument();
                    argParser.addArgument((Argument)noPropertiesFileArgument);
                    argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
                    baseDN = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"baseDN").shortIdentifier(Character.valueOf('b'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_BASEDN.get())).required()).valuePlaceholder(ToolsMessages.INFO_BASEDN_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    searchScope = CommonArguments.searchScopeArgument();
                    argParser.addArgument((Argument)searchScope);
                    proxyAuthzID = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"proxyAs").shortIdentifier(Character.valueOf('Y'))).description(ToolsMessages.INFO_DESCRIPTION_PROXY_AUTHZID.get())).valuePlaceholder(ToolsMessages.INFO_PROXYAUTHID_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    pSearchInfo = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"persistentSearch").shortIdentifier(Character.valueOf('C'))).description(ToolsMessages.INFO_DESCRIPTION_PSEARCH_INFO.get())).docDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_PSEARCH_INFO.get())).valuePlaceholder(ToolsMessages.INFO_PSEARCH_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    simplePageSize = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"simplePageSize").description(ToolsMessages.INFO_DESCRIPTION_SIMPLE_PAGE_SIZE.get())).lowerBound(1).defaultValue((Object)1000)).valuePlaceholder(CliMessages.INFO_NUM_ENTRIES_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    assertionFilter = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"assertionFilter").description(ToolsMessages.INFO_DESCRIPTION_ASSERTION_FILTER.get())).valuePlaceholder(ToolsMessages.INFO_ASSERTION_FILTER_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    matchedValuesFilter = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"matchedValuesFilter").description(ToolsMessages.INFO_DESCRIPTION_MATCHED_VALUES_FILTER.get())).multiValued()).valuePlaceholder(ToolsMessages.INFO_FILTER_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    sortOrder = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"sortOrder").shortIdentifier(Character.valueOf('S'))).description(ToolsMessages.INFO_DESCRIPTION_SORT_ORDER.get())).valuePlaceholder(ToolsMessages.INFO_SORT_ORDER_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    vlvDescriptor = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"virtualListView").shortIdentifier(Character.valueOf('G'))).description(ToolsMessages.INFO_DESCRIPTION_VLV.get())).valuePlaceholder(ToolsMessages.INFO_VLV_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    controlStr = CommonArguments.controlArgument();
                    argParser.addArgument((Argument)controlStr);
                    effectiveRightsUser = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"getEffectiveRightsAuthzid").shortIdentifier(Character.valueOf('g'))).description(ToolsMessages.INFO_DESCRIPTION_EFFECTIVERIGHTS_USER.get())).valuePlaceholder(ToolsMessages.INFO_PROXYAUTHID_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    effectiveRightsAttrs = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"getEffectiveRightsAttribute").shortIdentifier(Character.valueOf('e'))).description(ToolsMessages.INFO_DESCRIPTION_EFFECTIVERIGHTS_ATTR.get())).multiValued()).valuePlaceholder(ToolsMessages.INFO_ATTRIBUTE_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    dereferencePolicy = (MultiChoiceArgument)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)MultiChoiceArgument.builder((String)"dereferencePolicy").shortIdentifier(Character.valueOf('a'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_DEREFERENCE_POLICY.get())).allowedValues((Collection)DereferenceAliasesPolicy.values()).defaultValue((Object)DereferenceAliasesPolicy.NEVER)).valuePlaceholder(ToolsMessages.INFO_DEREFERENCE_POLICE_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    typesOnly = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"typesOnly").shortIdentifier(Character.valueOf('A'))).description(ToolsMessages.INFO_DESCRIPTION_TYPES_ONLY.get())).buildAndAddToParser((ArgumentParser)argParser);
                    sizeLimit = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"sizeLimit").shortIdentifier(Character.valueOf('z'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_SIZE_LIMIT.get())).defaultValue((Object)0)).valuePlaceholder(ToolsMessages.INFO_SIZE_LIMIT_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    timeLimit = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"timeLimit").shortIdentifier(Character.valueOf('l'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_TIME_LIMIT.get())).defaultValue((Object)0)).valuePlaceholder(ToolsMessages.INFO_TIME_LIMIT_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                    wrapColumn = CommonArguments.wrapColumnArgument();
                    argParser.addArgument((Argument)wrapColumn);
                    countEntries = (BooleanArgument)((BooleanArgument.Builder)BooleanArgument.builder((String)"countEntries").description(ToolsMessages.INFO_DESCRIPTION_COUNT_ENTRIES.get())).buildAndAddToParser((ArgumentParser)argParser);
                    subEntriesArgument = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"subEntries").shortIdentifier(ArgumentConstants.OPTION_SHORT_SUBENTRIES)).description(ToolsMessages.INFO_DESCRIPTION_SUBENTRIES.get())).buildAndAddToParser((ArgumentParser)argParser);
                    BooleanArgument continueOnError = CommonArguments.continueOnErrorArgument();
                    argParser.addArgument((Argument)continueOnError);
                    noop = CommonArguments.noOpArgument();
                    argParser.addArgument((Argument)noop);
                    this.verbose = CommonArguments.verboseArgument();
                    argParser.addArgument((Argument)this.verbose);
                    BooleanArgument showUsage = CommonArguments.showUsageArgument();
                    argParser.addArgument((Argument)showUsage);
                    argParser.setUsageArgument((Argument)showUsage, this.getOutputStream());
                }
                catch (ArgumentException ae) {
                    throw LDAPToolException.newToolParamException((Exception)((Object)ae), ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
                }
                argParser.parseArguments(args, this.getErrStream(), connectionFactoryProvider);
                if (argParser.usageOrVersionDisplayed()) {
                    return ResultCode.SUCCESS.intValue();
                }
                ArrayList trailingArgs = argParser.getTrailingArguments();
                Filter filter = Utils.readFilterFromString((String)trailingArgs.get(0));
                LinkedList attributes = new LinkedList();
                if (trailingArgs.size() > 1) {
                    attributes.addAll(trailingArgs.subList(1, trailingArgs.size()));
                }
                SearchScope scope = (SearchScope)searchScope.getTypedValue();
                try {
                    searchRequest = Requests.newSearchRequest((DN)DN.valueOf((String)baseDN.getValue()), (SearchScope)scope, (Filter)filter, (String[])attributes.toArray(new String[attributes.size()]));
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.errPrintln(e.getMessageObject());
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                searchRequest.setTypesOnly(typesOnly.isPresent()).setTimeLimit(timeLimit.getIntValue()).setSizeLimit(sizeLimit.getIntValue()).setDereferenceAliasesPolicy((DereferenceAliasesPolicy)dereferencePolicy.getTypedValue());
                Utils.addControlsToRequest((Request)searchRequest, Utils.readControls(controlStr));
                if (effectiveRightsUser.isPresent()) {
                    String authzID = effectiveRightsUser.getValue();
                    if (!authzID.startsWith("dn:")) {
                        throw LDAPToolException.newToolParamException(ToolsMessages.ERR_EFFECTIVERIGHTS_INVALID_AUTHZID.get((Object)authzID));
                    }
                    List attrValues = effectiveRightsAttrs.getValues();
                    searchRequest.addControl((Control)GetEffectiveRightsRequestControl.newControl((boolean)false, (String)authzID.substring(3), (String[])attrValues.toArray(new String[attrValues.size()])));
                }
                if (proxyAuthzID.isPresent()) {
                    searchRequest.addControl((Control)ProxiedAuthV2RequestControl.newControl((String)proxyAuthzID.getValue()));
                }
                if (pSearchInfo.isPresent()) {
                    searchRequest.addControl(this.computePSearchControl(pSearchInfo));
                }
                if (assertionFilter.isPresent()) {
                    searchRequest.addControl(Utils.readAssertionControl(assertionFilter.getValue()));
                }
                if (matchedValuesFilter.isPresent()) {
                    List mvFilterStrings = matchedValuesFilter.getValues();
                    ArrayList<Filter> mvFilters = new ArrayList<Filter>();
                    for (String s : mvFilterStrings) {
                        try {
                            mvFilters.add(Filter.valueOf((String)s));
                        }
                        catch (LocalizedIllegalArgumentException le) {
                            throw LDAPToolException.newToolParamException((Exception)((Object)le), ToolsMessages.ERR_LDAP_MATCHEDVALUES_INVALID_FILTER.get((Object)le.getMessage()));
                        }
                    }
                    searchRequest.addControl((Control)MatchedValuesRequestControl.newControl((boolean)true, mvFilters));
                }
                if (sortOrder.isPresent()) {
                    try {
                        searchRequest.addControl((Control)ServerSideSortRequestControl.newControl((boolean)false, (String)sortOrder.getValue()));
                    }
                    catch (LocalizedIllegalArgumentException le) {
                        throw LDAPToolException.newToolParamException((Exception)((Object)le), ToolsMessages.ERR_LDAP_SORTCONTROL_INVALID_ORDER.get((Object)le.getMessageObject()));
                    }
                }
                if (vlvDescriptor.isPresent()) {
                    searchRequest.addControl(this.readVLVControl(vlvDescriptor, sortOrder));
                }
                if (subEntriesArgument.isPresent()) {
                    searchRequest.addControl((Control)SubentriesRequestControl.newControl((boolean)true, (boolean)true));
                }
                int pageSize = 0;
                if (simplePageSize.isPresent()) {
                    pageSize = simplePageSize.getIntValue();
                    searchRequest.addControl((Control)SimplePagedResultsControl.newControl((boolean)true, (int)pageSize, (ByteString)ByteString.empty()));
                }
                if (noop.isPresent()) {
                    return ResultCode.SUCCESS.intValue();
                }
                connection = argParser.getConnectionFactory().getConnection();
                object = null;
                BindRequest bindRequest = argParser.getBindRequest();
                if (bindRequest != null) {
                    Utils.printPasswordPolicyResults(this, connection.bind(bindRequest));
                }
                this.ldifWriter = new LDIFEntryWriter((OutputStream)this.getOutputStream()).setWrapColumn(Utils.computeWrapColumn(wrapColumn));
                LDAPSearchResultHandler resultHandler = new LDAPSearchResultHandler();
                do {
                    ServerSideSortResponseControl control;
                    hasRemainingPages = false;
                    result = connection.search(searchRequest, (SearchResultHandler)resultHandler);
                    try {
                        control = (ServerSideSortResponseControl)result.getControl(ServerSideSortResponseControl.DECODER, new DecodeOptions());
                        if (control != null && ResultCode.SUCCESS != control.getResult()) {
                            this.println(ToolsMessages.WARN_LDAPSEARCH_SORT_ERROR.get((Object)control.getResult().toString()));
                        }
                    }
                    catch (DecodeException e) {
                        this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
                    }
                    try {
                        control = (VirtualListViewResponseControl)result.getControl(VirtualListViewResponseControl.DECODER, new DecodeOptions());
                        if (control != null) {
                            if (ResultCode.SUCCESS == control.getResult()) {
                                this.println(ToolsMessages.INFO_LDAPSEARCH_VLV_TARGET_OFFSET.get((Object)control.getTargetPosition()));
                                this.println(ToolsMessages.INFO_LDAPSEARCH_VLV_CONTENT_COUNT.get((Object)control.getContentCount()));
                            } else {
                                this.println(ToolsMessages.WARN_LDAPSEARCH_VLV_ERROR.get((Object)control.getResult().toString()));
                            }
                        }
                    }
                    catch (DecodeException e) {
                        this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
                    }
                    try {
                        control = (SimplePagedResultsControl)result.getControl(SimplePagedResultsControl.DECODER, new DecodeOptions());
                        if (control == null || control.getCookie().isEmpty()) continue;
                        if (!this.isQuiet()) {
                            this.pressReturnToContinue();
                        }
                        Iterator iterator = searchRequest.getControls().iterator();
                        while (iterator.hasNext()) {
                            if (!"1.2.840.113556.1.4.319".equals(((Control)iterator.next()).getOID())) continue;
                            iterator.remove();
                        }
                        control = SimplePagedResultsControl.newControl((boolean)true, (int)pageSize, (ByteString)control.getCookie());
                        searchRequest.addControl((Control)control);
                        hasRemainingPages = true;
                    }
                    catch (DecodeException e) {
                        this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
                    }
                } while (hasRemainingPages);
                Utils.printlnTextMsg(this, result.getDiagnosticMessage());
                Utils.printlnTextMsg(this, ToolsMessages.ERR_TOOL_MATCHED_DN, result.getMatchedDN());
                if (countEntries.isPresent() && !this.isQuiet()) {
                    this.println(ToolsMessages.INFO_LDAPSEARCH_MATCHING_ENTRY_COUNT.get((Object)resultHandler.entryCount));
                    this.println();
                }
                n = ResultCode.SUCCESS.intValue();
                if (connection == null) break block53;
                if (object == null) break block54;
                try {
                    connection.close();
                }
                catch (Throwable throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                break block53;
            }
            connection.close();
        }
        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{this.ldifWriter});
        return n;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (connection != null) {
                                if (object != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                } else {
                                    connection.close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                    catch (LdapException ere) {
                        int n2 = Utils.printErrorMessage((ConsoleApplication)this, ere, ToolsMessages.ERR_LDAP_SEARCH_FAILED);
                        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{this.ldifWriter});
                        return n2;
                    }
                }
                catch (Throwable throwable4) {
                    org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{this.ldifWriter});
                    throw throwable4;
                }
            }
        }
    }

    private Control readVLVControl(StringArgument vlvDescriptor, StringArgument sortOrder) throws LDAPToolException {
        if (!sortOrder.isPresent()) {
            throw LDAPToolException.newToolParamException(ToolsMessages.ERR_LDAPSEARCH_VLV_REQUIRES_SORT.get((Object)vlvDescriptor.getLongIdentifier(), (Object)sortOrder.getLongIdentifier()));
        }
        StringTokenizer tokenizer = new StringTokenizer(vlvDescriptor.getValue(), ":");
        int numTokens = tokenizer.countTokens();
        try {
            if (numTokens == 3) {
                int beforeCount = Integer.parseInt(tokenizer.nextToken());
                int afterCount = Integer.parseInt(tokenizer.nextToken());
                ByteString assertionValue = ByteString.valueOfUtf8((CharSequence)tokenizer.nextToken());
                return VirtualListViewRequestControl.newAssertionControl((boolean)true, (ByteString)assertionValue, (int)beforeCount, (int)afterCount, null);
            }
            if (numTokens == 4) {
                int beforeCount = Integer.parseInt(tokenizer.nextToken());
                int afterCount = Integer.parseInt(tokenizer.nextToken());
                int offset = Integer.parseInt(tokenizer.nextToken());
                int contentCount = Integer.parseInt(tokenizer.nextToken());
                return VirtualListViewRequestControl.newOffsetControl((boolean)true, (int)offset, (int)contentCount, (int)beforeCount, (int)afterCount, null);
            }
            throw LDAPToolException.newToolParamException(ToolsMessages.ERR_LDAPSEARCH_VLV_INVALID_DESCRIPTOR.get());
        }
        catch (Exception e) {
            throw LDAPToolException.newToolParamException(e, ToolsMessages.ERR_LDAPSEARCH_VLV_INVALID_DESCRIPTOR.get());
        }
    }

    private Control computePSearchControl(StringArgument pSearchInfo) throws LDAPToolException {
        String infoString = StaticUtils.toLowerCase((String)pSearchInfo.getValue().trim());
        StringTokenizer tokenizer = new StringTokenizer(infoString, ":");
        if (!tokenizer.hasMoreTokens()) {
            throw LDAPToolException.newToolParamException(ToolsMessages.ERR_PSEARCH_MISSING_DESCRIPTOR.get());
        }
        String pSearchToken = tokenizer.nextToken();
        if (!"ps".equals(pSearchToken)) {
            throw LDAPToolException.newToolParamException(ToolsMessages.ERR_PSEARCH_DOESNT_START_WITH_PS.get((Object)infoString));
        }
        ArrayList<PersistentSearchChangeType> pSearchChangeTypes = new ArrayList<PersistentSearchChangeType>(4);
        if (tokenizer.hasMoreTokens()) {
            StringTokenizer st = new StringTokenizer(tokenizer.nextToken(), ", ");
            if (!st.hasMoreTokens()) {
                this.addAllPersistentSearchChangeTypes(pSearchChangeTypes);
            } else {
                do {
                    this.addPersistentSearchChangeTypes(st.nextToken(), pSearchChangeTypes);
                } while (st.hasMoreTokens());
            }
        }
        boolean changesOnly = true;
        if (tokenizer.hasMoreTokens()) {
            changesOnly = this.readBooleanToken(tokenizer.nextToken(), ToolsMessages.ERR_PSEARCH_INVALID_CHANGESONLY);
        }
        boolean returnECs = true;
        if (tokenizer.hasMoreTokens()) {
            returnECs = this.readBooleanToken(tokenizer.nextToken(), ToolsMessages.ERR_PSEARCH_INVALID_RETURN_ECS);
        }
        return PersistentSearchRequestControl.newControl((boolean)true, (boolean)changesOnly, (boolean)returnECs, (PersistentSearchChangeType[])pSearchChangeTypes.toArray(new PersistentSearchChangeType[pSearchChangeTypes.size()]));
    }

    private boolean readBooleanToken(String token, LocalizableMessageDescriptor.Arg1<Object> errorMsg) throws LDAPToolException {
        switch (token) {
            case "1": 
            case "true": 
            case "yes": {
                return true;
            }
            case "0": 
            case "false": 
            case "no": {
                return false;
            }
        }
        throw LDAPToolException.newToolParamException(errorMsg.get((Object)token));
    }

    private void addPersistentSearchChangeTypes(String token, List<PersistentSearchChangeType> pSearchChangeTypes) throws LDAPToolException {
        switch (token) {
            case "add": {
                pSearchChangeTypes.add(PersistentSearchChangeType.ADD);
                break;
            }
            case "del": 
            case "delete": {
                pSearchChangeTypes.add(PersistentSearchChangeType.DELETE);
                break;
            }
            case "mod": 
            case "modify": {
                pSearchChangeTypes.add(PersistentSearchChangeType.MODIFY);
                break;
            }
            case "moddn": 
            case "modrdn": 
            case "modifydn": {
                pSearchChangeTypes.add(PersistentSearchChangeType.MODIFY_DN);
                break;
            }
            case "any": 
            case "all": {
                this.addAllPersistentSearchChangeTypes(pSearchChangeTypes);
                break;
            }
            default: {
                throw LDAPToolException.newToolParamException(ToolsMessages.ERR_PSEARCH_INVALID_CHANGE_TYPE.get((Object)token));
            }
        }
    }

    private void addAllPersistentSearchChangeTypes(List<PersistentSearchChangeType> pSearchChangeTypes) {
        pSearchChangeTypes.add(PersistentSearchChangeType.ADD);
        pSearchChangeTypes.add(PersistentSearchChangeType.DELETE);
        pSearchChangeTypes.add(PersistentSearchChangeType.MODIFY);
        pSearchChangeTypes.add(PersistentSearchChangeType.MODIFY_DN);
    }

    private class LDAPSearchResultHandler
    implements SearchResultHandler {
        private int entryCount;

        private LDAPSearchResultHandler() {
        }

        public boolean handleEntry(SearchResultEntry entry) {
            EntryChangeNotificationResponseControl control;
            ++this.entryCount;
            try {
                control = (EntryChangeNotificationResponseControl)entry.getControl(EntryChangeNotificationResponseControl.DECODER, new DecodeOptions());
                if (control != null) {
                    LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_PSEARCH_CHANGE_TYPE.get((Object)control.getChangeType().toString()));
                    DN previousDN = control.getPreviousName();
                    if (previousDN != null) {
                        LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_PSEARCH_PREVIOUS_DN.get((Object)previousDN.toString()));
                    }
                }
            }
            catch (DecodeException de) {
                LDAPSearch.this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)de.getLocalizedMessage()));
            }
            try {
                control = (AccountUsabilityResponseControl)entry.getControl(AccountUsabilityResponseControl.DECODER, new DecodeOptions());
                if (control != null) {
                    LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_HEADER.get());
                    if (control.isUsable()) {
                        LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_IS_USABLE.get());
                        if (control.getSecondsBeforeExpiration() > 0) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_TIME_UNTIL_EXPIRATION.get((Object)com.forgerock.opendj.cli.Utils.secondsToTimeString((int)control.getSecondsBeforeExpiration())));
                        }
                    } else {
                        LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_NOT_USABLE.get());
                        if (control.isInactive()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_ACCT_INACTIVE.get());
                        }
                        if (control.isReset()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_PW_RESET.get());
                        }
                        if (control.isExpired()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_PW_EXPIRED.get());
                            if (control.getRemainingGraceLogins() > 0) {
                                LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_REMAINING_GRACE.get((Object)control.getRemainingGraceLogins()));
                            }
                        }
                        if (control.isLocked()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_LOCKED.get());
                            if (control.getSecondsBeforeUnlock() > 0) {
                                LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_TIME_UNTIL_UNLOCK.get((Object)com.forgerock.opendj.cli.Utils.secondsToTimeString((int)control.getSecondsBeforeUnlock())));
                            }
                        }
                    }
                }
            }
            catch (DecodeException de) {
                LDAPSearch.this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)de.getLocalizedMessage()));
            }
            try {
                LDAPSearch.this.ldifWriter.writeEntry((Entry)entry);
                LDAPSearch.this.ldifWriter.flush();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return true;
        }

        public boolean handleReference(SearchResultReference reference) {
            LDAPSearch.this.println(LocalizableMessage.raw((CharSequence)reference.toString(), (Object[])new Object[0]));
            return true;
        }
    }
}

