/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import com.forgerock.opendj.util.ReferenceCountedObject;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.PooledMemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

final class ServerTCPNIOTransport
extends ReferenceCountedObject<TCPNIOTransport> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    static final ServerTCPNIOTransport SERVER_TRANSPORT = new ServerTCPNIOTransport();

    private ServerTCPNIOTransport() {
    }

    protected void destroyInstance(TCPNIOTransport instance) {
        try {
            instance.shutdownNow();
        }
        catch (IOException e) {
            logger.warn(LocalizableMessage.raw((CharSequence)"An error occurred while shutting down the Grizzly transport", (Object[])new Object[]{e}));
        }
    }

    protected TCPNIOTransport newInstance() {
        String reuseAddressStr;
        String tcpNoDelayStr;
        TCPNIOTransportBuilder builder = TCPNIOTransportBuilder.newInstance();
        builder.setIOStrategy((IOStrategy)SameThreadIOStrategy.getInstance());
        int cpus = Runtime.getRuntime().availableProcessors();
        String selectorsStr = System.getProperty("org.forgerock.opendj.transport.selectors");
        int selectorThreadCount = selectorsStr != null ? Integer.parseInt(selectorsStr) : Math.max(5, cpus / 2 - 1);
        builder.setSelectorThreadPoolConfig(ThreadPoolConfig.defaultConfig().setCorePoolSize(selectorThreadCount).setMaxPoolSize(selectorThreadCount).setPoolName("OpenDJ LDAP SDK Grizzly selector thread"));
        String lingerStr = System.getProperty("org.forgerock.opendj.transport.linger");
        if (lingerStr != null) {
            builder.setLinger(Integer.parseInt(lingerStr));
        }
        if ((tcpNoDelayStr = System.getProperty("org.forgerock.opendj.transport.tcpNoDelay")) != null) {
            builder.setTcpNoDelay(Boolean.parseBoolean(tcpNoDelayStr));
        }
        if ((reuseAddressStr = System.getProperty("org.forgerock.opendj.transport.reuseAddress")) != null) {
            builder.setReuseAddress(Boolean.parseBoolean(reuseAddressStr));
        }
        builder.setMemoryManager((MemoryManager)new PooledMemoryManager(true));
        TCPNIOTransport transport = builder.build();
        transport.setSelectorRunnersCount(selectorThreadCount);
        try {
            transport.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return transport;
    }
}

