/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils.file;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static List<String> generateZip(String srcFolder, String outputZip) throws IOException, URISyntaxException {
        final Path targetZip = Paths.get(outputZip, new String[0]);
        final Path sourceDir = Paths.get(srcFolder, new String[0]);
        URI uri = new URI("jar", URLDecoder.decode(targetZip.toUri().toString(), "UTF-8"), null);
        final ArrayList<String> files = new ArrayList<String>();
        try (final FileSystem zipfs = FileSystems.newFileSystem(uri, Collections.singletonMap("create", "true"));){
            Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (targetZip.equals(file)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path target = zipfs.getPath(sourceDir.relativize(file).toString(), new String[0]);
                    if (target.getParent() != null) {
                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING);
                    files.add(file.toString());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return files;
    }
}

