/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.forgerock.openam.utils.collections.PrefixSet;

public final class SimplePrefixSet
implements PrefixSet {
    private final List<String> prefixes;

    public SimplePrefixSet(Collection<String> prefixes) {
        this.prefixes = new ArrayList<String>(prefixes);
    }

    public static SimplePrefixSet of(String ... prefixes) {
        return new SimplePrefixSet(Arrays.asList(prefixes));
    }

    @Override
    public boolean containsPrefixOf(String toMatch) {
        for (String prefix : this.prefixes) {
            if (!toMatch.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

