/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.forgerock.openam.utils.CollectionUtils;
import org.forgerock.util.Reject;

public final class StringUtils {
    private StringUtils() {
    }

    public static String tagSwap(String content, Map<String, String> tagSwapMap) {
        for (Map.Entry<String, String> entry : tagSwapMap.entrySet()) {
            content = content.replace(entry.getKey(), entry.getValue());
        }
        return content;
    }

    public static String insertContent(String original, int position, String content) {
        return original.substring(0, position) + content + original.substring(position);
    }

    public static List<String> getParameter(String list, String delimiter, String parameterName) {
        String[] parameters = null;
        if (list != null) {
            parameters = list.split(delimiter);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (parameters != null) {
            for (String parameter : parameters) {
                String[] valueParameterPair = parameter.split("=");
                String currentParameterName = valueParameterPair[0];
                if (currentParameterName == null || !parameterName.equals(currentParameterName.trim()) || valueParameterPair.length != 2) continue;
                result.add(valueParameterPair[1]);
            }
        }
        return result;
    }

    public static String ifNullOrEmpty(String original, String defaultString) {
        Reject.ifNull((Object)defaultString, (String)"Default string must not be null");
        return original == null || original.isEmpty() ? defaultString : original;
    }

    public static String encodeURIComponent(String component, String encoding) throws UnsupportedEncodingException {
        if (component == null) {
            return null;
        }
        String result = URLEncoder.encode(component, encoding).replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\+", "%20").replaceAll("\\%27", "'").replaceAll("\\%21", "!").replaceAll("\\%7E", "~");
        return result;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean isNotBlank(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static boolean isAnyBlank(Set<String> xs) {
        if (xs == null || xs.isEmpty()) {
            return true;
        }
        for (String x : xs) {
            if (!StringUtils.isBlank(x)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualTo(String s1, String s2) {
        return CollectionUtils.genericCompare(s1, s2);
    }

    public static boolean compareCaseInsensitiveString(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equalsIgnoreCase(s2);
    }

    public static boolean contains(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.contains(s2);
    }

    public static boolean containsCaseInsensitive(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.toLowerCase().contains(s2.toLowerCase());
    }

    public static boolean startsWith(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.startsWith(s2);
    }

    public static boolean match(String value, String strPattern) {
        if (StringUtils.isNotEmpty(strPattern)) {
            if (StringUtils.isBlank(value)) {
                return strPattern.equals("*");
            }
            value = value.toLowerCase();
            strPattern = strPattern.toLowerCase();
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < strPattern.length() - 1; ++i) {
                char c = strPattern.charAt(i);
                if (c == '*') {
                    buff.append(".*?");
                    continue;
                }
                buff.append(c);
            }
            char lastChar = strPattern.charAt(strPattern.length() - 1);
            if (lastChar == '*') {
                buff.append(".*");
            } else {
                buff.append(lastChar);
            }
            return Pattern.matches(buff.toString(), value);
        }
        return true;
    }

    public static List<String> split(String content, Pattern pattern) {
        List<String> result = Collections.emptyList();
        if (content != null) {
            result = Arrays.asList(pattern.split(content));
        }
        return result;
    }
}

