/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import org.forgerock.openam.utils.CipherProvider;
import org.forgerock.openam.utils.DocumentBuilderProvider;
import org.forgerock.openam.utils.JCECipherProvider;
import org.forgerock.openam.utils.PerThreadCipherProvider;
import org.forgerock.openam.utils.PerThreadDocumentBuilderProvider;
import org.forgerock.openam.utils.PerThreadSAXParserProvider;
import org.forgerock.openam.utils.PerThreadTransformerFactoryProvider;
import org.forgerock.openam.utils.SAXParserProvider;
import org.forgerock.openam.utils.SafeDocumentBuilderProvider;
import org.forgerock.openam.utils.SafeSAXParserProvider;
import org.forgerock.openam.utils.TransformerFactoryProvider;

public final class Providers {
    private Providers() {
    }

    public static CipherProvider cipherProvider(String transformation, String preferredProvider, int maxSize) {
        return new PerThreadCipherProvider(new JCECipherProvider(transformation, preferredProvider), maxSize);
    }

    public static DocumentBuilderProvider documentBuilderProvider(int maxSize) {
        return new PerThreadDocumentBuilderProvider(new SafeDocumentBuilderProvider(), maxSize);
    }

    public static SAXParserProvider saxParserProvider(int maxSize) {
        return new PerThreadSAXParserProvider(new SafeSAXParserProvider(), maxSize);
    }

    public static TransformerFactoryProvider transformerFactoryProvider(int maxSize) {
        return new PerThreadTransformerFactoryProvider(maxSize);
    }
}

