/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import javax.crypto.Cipher;
import org.forgerock.openam.utils.CipherProvider;
import org.forgerock.openam.utils.PerThreadCache;

public class PerThreadCipherProvider
implements CipherProvider {
    private static final int DEFAULT_MAX_SIZE = 500;
    private final PerThreadCache<Cipher, RuntimeException> cipherCache;

    public PerThreadCipherProvider(final CipherProvider delegate, int maxSize) {
        if (delegate == null) {
            throw new NullPointerException("Must specify a valid delegate CipherProvider");
        }
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be positive");
        }
        this.cipherCache = new PerThreadCache<Cipher, RuntimeException>(maxSize){

            @Override
            protected Cipher initialValue() {
                return delegate.getCipher();
            }
        };
    }

    public PerThreadCipherProvider(CipherProvider delegate) {
        this(delegate, 500);
    }

    @Override
    public Cipher getCipher() {
        return this.cipherCache.getInstanceForCurrentThread();
    }
}

