/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public final class MappingUtils {
    private static Debug debug = Debug.getInstance("amAuth");
    private static final String EQUALS = "=";

    private MappingUtils() {
    }

    public static Map<String, String> parseMappings(Set<String> configuredMappings) {
        HashMap<String, String> parsedMappings = new HashMap<String, String>();
        for (String mapping : configuredMappings) {
            if (mapping.indexOf(EQUALS) == -1) continue;
            StringTokenizer tokenizer = new StringTokenizer(mapping, EQUALS);
            String key = tokenizer.nextToken();
            String value = tokenizer.nextToken();
            if (!parsedMappings.containsKey(key)) {
                parsedMappings.put(key, value);
                continue;
            }
            if (!debug.warningEnabled()) continue;
            debug.warning("In MappingUtils.parseMappings, the user-entered attribute mappings contain duplicate entries. The first entry will be preserved: " + configuredMappings);
        }
        if (parsedMappings.isEmpty()) {
            throw new IllegalArgumentException("The mapping Set does not contain any mappings in format local_attribute=source_attribute.");
        }
        return Collections.unmodifiableMap(parsedMappings);
    }
}

