/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.shared.debug.Debug;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import org.forgerock.openam.utils.IOUtils;

public final class MapHelper {
    private static final Debug DEBUG = Debug.getInstance("workflow");

    private MapHelper() {
    }

    public static Map<String, Set<String>> readMap(String fileName) throws IOException {
        InputStream is = null;
        try {
            is = MapHelper.class.getResourceAsStream(fileName);
            if (is == null) {
                DEBUG.warning("Could not locate properties file " + fileName);
                CaseInsensitiveHashMap<String, Set<String>> caseInsensitiveHashMap = new CaseInsensitiveHashMap<String, Set<String>>();
                return caseInsensitiveHashMap;
            }
            Map<String, Set<String>> map = MapHelper.readMap(is);
            return map;
        }
        finally {
            IOUtils.closeIfNotNull((Closeable)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Set<String>> readMap(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            CaseInsensitiveHashMap<String, Set<String>> result = new CaseInsensitiveHashMap<String, Set<String>>();
            while ((line = br.readLine()) != null) {
                int idx;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || (idx = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                if (value.isEmpty()) continue;
                CaseInsensitiveHashSet values = (CaseInsensitiveHashSet)result.get(key);
                if (values == null) {
                    values = new CaseInsensitiveHashSet(1);
                }
                values.add(value);
                result.put(key, values);
            }
            CaseInsensitiveHashMap<String, Set<String>> caseInsensitiveHashMap = result;
            return caseInsensitiveHashMap;
        }
        finally {
            IOUtils.closeIfNotNull((Closeable)br);
        }
    }
}

