/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import com.sun.identity.shared.debug.Debug;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.forgerock.openam.utils.CipherProvider;

public class JCECipherProvider
implements CipherProvider {
    private static final Debug DEBUG = Debug.getInstance("amSDK");
    private final String transformation;
    private final Provider preferredProvider;

    public JCECipherProvider(String transformation, String preferredProvider) {
        this(transformation, Security.getProvider(preferredProvider));
    }

    public JCECipherProvider(String transformation, Provider preferredProvider) {
        if (transformation == null) {
            throw new IllegalArgumentException("Cipher transformation cannot be null");
        }
        this.transformation = transformation;
        this.preferredProvider = preferredProvider;
    }

    @Override
    public Cipher getCipher() {
        try {
            return this.preferredProvider != null ? Cipher.getInstance(this.transformation, this.preferredProvider) : Cipher.getInstance(this.transformation);
        }
        catch (NoSuchAlgorithmException ex) {
            DEBUG.error("JCECipherProvider: Algorithm doesn't exist: " + this.transformation, ex);
        }
        catch (NoSuchPaddingException ex) {
            DEBUG.error("JCECipherProvider: Padding doesn't exist: " + this.transformation, ex);
        }
        return null;
    }
}

