/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import com.sun.identity.common.CaseInsensitiveHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.openam.utils.StringUtils;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static Set<String> removeBlankEntries(Set<String> originalSet) {
        if (CollectionUtils.isEmpty(originalSet)) {
            return originalSet;
        }
        HashSet<String> result = new HashSet<String>(originalSet.size());
        for (String entry : originalSet) {
            if (!StringUtils.isNotBlank(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    public static <T> List<T> asList(T ... values) {
        if (values == null) {
            return new ArrayList(0);
        }
        return new ArrayList<T>(Arrays.asList(values));
    }

    public static Set asCaseInsensitiveHashSet(Object ... values) {
        if (values == null) {
            return new CaseInsensitiveHashSet(0);
        }
        return new CaseInsensitiveHashSet(Arrays.asList(values));
    }

    public static <T> Set<T> asSet(T ... values) {
        if (values == null) {
            return new HashSet(0);
        }
        return new HashSet<T>(Arrays.asList(values));
    }

    public static <T> LinkedHashSet<T> asOrderedSet(T ... values) {
        if (values == null) {
            return new LinkedHashSet(0);
        }
        return new LinkedHashSet<T>(Arrays.asList(values));
    }

    public static <K, V> Map<V, K> invertMap(Map<K, V> map) {
        Reject.ifNull(map);
        HashMap<V, K> newMap = new HashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            newMap.put(entry.getValue(), entry.getKey());
        }
        return newMap;
    }

    public static <K, I, M, E extends Exception> Map<K, M> transformMap(Map<K, I> map, Function<I, M, E> mapper) throws E {
        Reject.ifNull((Object[])new Object[]{map, mapper});
        HashMap<K, Object> newMap = new HashMap<K, Object>(map.size());
        for (Map.Entry<K, I> entry : map.entrySet()) {
            newMap.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
        return newMap;
    }

    public static <I, M, E extends Exception> List<M> transformList(Collection<I> values, Function<I, M, E> mapper) throws E {
        Reject.ifNull((Object[])new Object[]{values, mapper});
        ArrayList<Object> newList = new ArrayList<Object>(values.size());
        for (I value : values) {
            newList.add(mapper.apply(value));
        }
        return newList;
    }

    public static <I, M, E extends Exception> Set<M> transformSet(Collection<I> values, Function<I, M, E> mapper) throws E {
        Reject.ifNull((Object[])new Object[]{values, mapper});
        HashSet<Object> newSet = new HashSet<Object>(values.size());
        for (I value : values) {
            newSet.add(mapper.apply(value));
        }
        return newSet;
    }

    public static <T> T getFirstItem(Collection<T> collection) {
        return CollectionUtils.getFirstItem(collection, null);
    }

    public static <T> T getFirstItem(Collection<T> collection, T defaultValue) {
        if (collection == null) {
            return defaultValue;
        }
        Iterator<T> iterator = collection.iterator();
        return iterator.hasNext() ? iterator.next() : defaultValue;
    }

    public static <T> boolean genericCompare(T valA, T valB) {
        return valA == null ? valB == null : valA.equals(valB);
    }

    public static boolean compareCaseInsensitiveMapOfSetOfStrings(Map<String, Set<String>> valA, Map<String, Set<String>> valB) {
        if (valA == valB) {
            return true;
        }
        if (valA == null || valB == null) {
            return false;
        }
        if (valA.size() != valB.size()) {
            return false;
        }
        if (valA.size() == 0) {
            return true;
        }
        for (Map.Entry<String, Set<String>> valAEntry : valA.entrySet()) {
            Set<String> valBValues = valB.get(valAEntry.getKey());
            Set<String> valAValues = valAEntry.getValue();
            if (valBValues == null) {
                if (valAValues == null) continue;
                return false;
            }
            if (valAValues.size() != valBValues.size()) {
                return false;
            }
            if (valAValues.size() == 0) continue;
            for (String valAValueString : valAValues) {
                String valBValueString;
                Iterator<String> iterator;
                if (valAValueString == null) {
                    String nullTestInValBString;
                    boolean bFoundNull = false;
                    iterator = valBValues.iterator();
                    while (iterator.hasNext() && !(bFoundNull = (nullTestInValBString = iterator.next()) == null)) {
                    }
                    if (bFoundNull) continue;
                    return false;
                }
                boolean bFound = false;
                iterator = valBValues.iterator();
                while (iterator.hasNext() && !(bFound = StringUtils.compareCaseInsensitiveString(valAValueString, valBValueString = iterator.next()))) {
                }
                if (bFound) continue;
                return false;
            }
        }
        return true;
    }

    public static int createHashForCaseInsensitiveMapOfSetOfStrings(Map<String, Set<String>> map) {
        int hc = 0;
        for (Map.Entry<String, Set<String>> currentEntry : map.entrySet()) {
            Set<String> currentValue;
            if (currentEntry == null || (currentValue = currentEntry.getValue()) == null) continue;
            for (String currentString : currentValue) {
                if (currentString == null) continue;
                hc = hc * 31 + currentString.toLowerCase().hashCode();
            }
        }
        return hc;
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static Map<String, Set<String>> toAvPairMap(Set<String> names, String value) {
        if (value == null) {
            return Collections.EMPTY_MAP;
        }
        if (names == null || names.isEmpty()) {
            return new HashMap<String, Set<String>>();
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(names.size());
        HashSet<String> set = new HashSet<String>(1);
        set.add(value);
        for (String name : names) {
            map.put(name, set);
        }
        return map;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static boolean anyHaveEntries(Object ... containers) {
        for (Object o : containers) {
            if (o instanceof Collection && CollectionUtils.isNotEmpty((Collection)o)) {
                return true;
            }
            if (!(o instanceof Map) || !CollectionUtils.isNotEmpty((Map)o)) continue;
            return true;
        }
        return false;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortMapByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> sortedEntries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(sortedEntries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> entry1, Map.Entry<K, V> entry2) {
                Comparable value1 = (Comparable)entry1.getValue();
                Comparable value2 = (Comparable)entry2.getValue();
                if (value1 == null && value2 == null) {
                    return 0;
                }
                if (value1 == null) {
                    return -1;
                }
                if (value2 == null) {
                    return 1;
                }
                return value1.compareTo(value2);
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : sortedEntries) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <T> List<T> newList(Collection<T> collection) {
        return collection == null ? null : new ArrayList<T>(collection);
    }
}

