/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.forgerock.http.protocol.Request;
import org.forgerock.json.resource.http.HttpContext;
import org.forgerock.openam.utils.CollectionUtils;
import org.forgerock.openam.utils.StringUtils;
import org.forgerock.services.context.ClientContext;
import org.forgerock.services.context.Context;

public final class ClientUtils {
    private static Debug utilDebug = Debug.getInstance("amComm");

    private ClientUtils() {
    }

    public static String getClientIPAddress(HttpServletRequest request) {
        String result = null;
        if (request != null) {
            String ipAddrHeader = SystemPropertiesManager.get("com.sun.identity.authentication.client.ipAddressHeader");
            if (ipAddrHeader != null && ipAddrHeader.length() != 0 && (result = request.getHeader(ipAddrHeader)) != null) {
                String[] ips = result.split(",");
                result = ips[0].trim();
            }
            if (result == null || result.length() == 0) {
                result = request.getRemoteAddr();
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("ClientUtils.getClientIPAddress : remoteAddr=[" + result + "]");
                }
            } else if (utilDebug.messageEnabled()) {
                utilDebug.message("ClientUtils.getClientIPAddress : header=[" + ipAddrHeader + "], result=[" + result + "]");
            }
        }
        return result;
    }

    public static String getClientIPAddress(Context context, Request request) {
        String result = null;
        if (request != null) {
            String ipAddrHeader = SystemPropertiesManager.get("com.sun.identity.authentication.client.ipAddressHeader");
            if (!StringUtils.isBlank(ipAddrHeader) && (result = request.getHeaders().getFirst(ipAddrHeader)) != null) {
                String[] ips = result.split(",");
                result = ips[0].trim();
            }
            if (StringUtils.isBlank(result)) {
                result = ((ClientContext)context.asContext(ClientContext.class)).getRemoteAddress();
                if (utilDebug.messageEnabled()) {
                    utilDebug.message("ClientUtils.getClientIPAddress : remoteAddr=[" + result + "]");
                }
            } else if (utilDebug.messageEnabled()) {
                utilDebug.message("ClientUtils.getClientIPAddress : header=[" + ipAddrHeader + "], result=[" + result + "]");
            }
        }
        return result;
    }

    public static String getClientIPAddress(Context context) {
        List clientIPHeaderContent;
        String result = null;
        String ipAddrHeader = SystemPropertiesManager.get("com.sun.identity.authentication.client.ipAddressHeader");
        if (!StringUtils.isBlank(ipAddrHeader) && !CollectionUtils.isEmpty(clientIPHeaderContent = (List)((HttpContext)context.asContext(HttpContext.class)).getHeaders().get(ipAddrHeader)) && (result = (String)clientIPHeaderContent.get(0)) != null) {
            String[] ips = result.split(",");
            result = ips[0].trim();
        }
        if (StringUtils.isBlank(result)) {
            result = ((ClientContext)context.asContext(ClientContext.class)).getRemoteAddress();
            if (utilDebug.messageEnabled()) {
                utilDebug.message("ClientUtils.getClientIPAddress : remoteAddr=[" + result + "]");
            }
        } else if (utilDebug.messageEnabled()) {
            utilDebug.message("ClientUtils.getClientIPAddress : header=[" + ipAddrHeader + "], result=[" + result + "]");
        }
        return result;
    }
}

