/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.utils;

import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.SecurityDebug;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import org.forgerock.openam.keystore.KeyStoreConfig;

public class AMKeyProvider
implements KeyProvider {
    private static final String DEFAULT_KEYSTORE_FILE_PROP = "com.sun.identity.saml.xmlsig.keystore";
    private static final String DEFAULT_KEYSTORE_PASS_FILE_PROP = "com.sun.identity.saml.xmlsig.storepass";
    private static final String DEFAULT_KEYSTORE_TYPE_PROP = "com.sun.identity.saml.xmlsig.storetype";
    private static final String DEFAULT_PRIVATE_KEY_PASS_FILE_PROP = "com.sun.identity.saml.xmlsig.keypass";
    private Debug logger = SecurityDebug.debug;
    private KeyStore ks = null;
    private String privateKeyPass = null;
    private String keystorePass = "";
    private String keystoreFile = "";
    private String keystoreType = "JKS";
    private String storePassPath;
    private String keyPassPath;
    HashMap keyTable = new HashMap();
    private static Map<String, PrivateKey> mapKey = new ConcurrentHashMap<String, PrivateKey>();

    public AMKeyProvider() {
        this(DEFAULT_KEYSTORE_FILE_PROP, DEFAULT_KEYSTORE_PASS_FILE_PROP, DEFAULT_KEYSTORE_TYPE_PROP, DEFAULT_PRIVATE_KEY_PASS_FILE_PROP);
    }

    public AMKeyProvider(KeyStoreConfig kc) throws KeyStoreException, IOException {
        this.keystoreFile = kc.getKeyStoreFile();
        this.keystorePass = new String(kc.getKeyStorePassword());
        this.privateKeyPass = new String(kc.getKeyPassword());
        this.keystoreType = kc.getKeyStoreType();
        this.storePassPath = kc.getKeyStorePasswordFile();
        this.keyPassPath = kc.getKeyPasswordFile();
        this.mapPk2Cert();
    }

    public AMKeyProvider(String keyStoreFilePropName, String keyStorePassFilePropName, String keyStoreTypePropName, String privateKeyPassFilePropName) {
        this.initialize(keyStoreFilePropName, keyStorePassFilePropName, keyStoreTypePropName, privateKeyPassFilePropName);
        this.mapPk2Cert();
    }

    public AMKeyProvider(boolean alreadyResolved, String keyStoreFile, String keyStorePass, String keyStoreType, String privateKeyPass) {
        this.keystoreFile = keyStoreFile;
        this.keystoreType = keyStoreType;
        this.keystorePass = keyStorePass;
        this.privateKeyPass = privateKeyPass;
        this.mapPk2Cert();
    }

    private void initialize(String keyStoreFilePropName, String keyStorePassFilePropName, String keyStoreTypePropName, String privateKeyPassFilePropName) {
        Object br = null;
        this.keystoreFile = SystemPropertiesManager.get(keyStoreFilePropName);
        if (this.keystoreFile == null || this.keystoreFile.length() == 0) {
            this.logger.error("JKSKeyProvider: keystore file does not exist");
        }
        this.storePassPath = SystemPropertiesManager.get(keyStorePassFilePropName);
        String tmpKsType = SystemPropertiesManager.get(keyStoreTypePropName);
        if (null != tmpKsType) {
            this.keystoreType = tmpKsType.trim();
        }
        if (this.storePassPath != null) {
            this.keystorePass = this.readPasswordFile(this.storePassPath);
        } else {
            this.logger.error("JKSKeyProvider: keystore password is null");
        }
        this.keyPassPath = SystemPropertiesManager.get(privateKeyPassFilePropName);
        if (this.keyPassPath != null) {
            this.privateKeyPass = this.readPasswordFile(this.keyPassPath);
        }
    }

    protected String readPasswordFile(String filePath) {
        String p = null;
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            p = br.readLine();
            p = AMKeyProvider.decodePassword(p);
        }
        catch (IOException e) {
            this.logger.error("Unable to read private key password file " + filePath, e);
        }
        return p;
    }

    public static String decodePassword(String password) {
        String decodedPassword = AccessController.doPrivileged(new DecodeAction(password));
        return decodedPassword == null ? password : decodedPassword;
    }

    private void mapPk2Cert() {
        try {
            this.ks = KeyStore.getInstance(this.keystoreType);
            if (this.keystoreFile == null || this.keystoreFile.isEmpty()) {
                this.logger.error("mapPk2Cert.JKSKeyProvider: KeyStore FileName is null, unable to establish Mapping Public Keys to Certificates!");
                return;
            }
            FileInputStream fis = new FileInputStream(this.keystoreFile);
            this.ks.load(fis, this.keystorePass.toCharArray());
            Enumeration<String> e = this.ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                if (this.ks.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) continue;
                Certificate cert = this.getCertificate(alias);
                PublicKey pk = this.getPublicKey(alias);
                String key = Base64.encode(pk.getEncoded());
                this.keyTable.put(key, cert);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            this.logger.error("mapPk2Cert.JKSKeyProvider:", e);
        }
    }

    public void setLogger(Debug logger) {
        this.logger = logger;
    }

    @Override
    public void setKey(String storepass, String keypass) {
        this.keystorePass = storepass;
        this.privateKeyPass = keypass;
    }

    @Override
    public X509Certificate getX509Certificate(String certAlias) {
        if (certAlias == null || certAlias.length() == 0) {
            return null;
        }
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)this.ks.getCertificate(certAlias);
        }
        catch (KeyStoreException e) {
            this.logger.error("Unable to get cert alias:" + certAlias, e);
        }
        return cert;
    }

    @Override
    public PublicKey getPublicKey(String keyAlias) {
        if (keyAlias == null || keyAlias.length() == 0) {
            return null;
        }
        PublicKey pkey = null;
        try {
            X509Certificate cert = (X509Certificate)this.ks.getCertificate(keyAlias);
            if (cert == null) {
                this.logger.error("Unable to retrieve certificate with alias '" + keyAlias + "' from keystore '" + this.keystoreFile + "'");
                return null;
            }
            pkey = cert.getPublicKey();
        }
        catch (KeyStoreException e) {
            this.logger.error("Unable to get public key:" + keyAlias, e);
        }
        return pkey;
    }

    @Override
    public PrivateKey getPrivateKey(String certAlias) {
        PrivateKey key = null;
        try {
            key = (PrivateKey)this.ks.getKey(certAlias, this.privateKeyPass.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            this.logger.error(e.getMessage());
        }
        return key;
    }

    @Override
    public SecretKey getSecretKey(String certAlias) {
        try {
            Key key = this.ks.getKey(certAlias, this.privateKeyPass.toCharArray());
            if (key instanceof SecretKey) {
                return (SecretKey)key;
            }
            if (key != null) {
                this.logger.error("Expected a key of type javax.crypto.SecretKey but got " + key.getClass().getName());
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            this.logger.error("Unable to get the secret key for certificate alias " + certAlias, e);
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String certAlias, String encryptedKeyPass) {
        PrivateKey key = null;
        String keyPass = AMKeyProvider.decodePassword(encryptedKeyPass);
        if (keyPass != null) {
            try {
                key = (PrivateKey)this.ks.getKey(certAlias, keyPass.toCharArray());
            }
            catch (KeyStoreException e) {
                this.logger.error(e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error(e.getMessage());
            }
            catch (UnrecoverableKeyException e) {
                this.logger.error(e.getMessage());
            }
        } else {
            this.logger.error("AMKeyProvider.getPrivateKey: null key password returned from decryption for certificate alias:" + certAlias + " The password maybe incorrect.");
        }
        return key;
    }

    public KeyPair getKeyPair(String certAlias) {
        PublicKey publicKey = this.getPublicKey(certAlias);
        PrivateKey privateKey = null;
        if (mapKey.containsKey(certAlias)) {
            privateKey = mapKey.get(certAlias);
        } else {
            privateKey = this.getPrivateKey(certAlias);
            mapKey.putIfAbsent(certAlias, privateKey);
        }
        if (publicKey != null && privateKey != null) {
            return new KeyPair(publicKey, privateKey);
        }
        return null;
    }

    @Override
    public String getCertificateAlias(Certificate cert) {
        String certalias = null;
        try {
            if (this.ks != null) {
                certalias = this.ks.getCertificateAlias(cert);
            }
        }
        catch (KeyStoreException ke) {
            return null;
        }
        return certalias;
    }

    public char[] getKeystorePass() {
        return this.keystorePass.toCharArray();
    }

    public String getPrivateKeyPass() {
        return this.privateKeyPass;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeystoreFilePath() {
        return this.keystoreFile;
    }

    public String getKeystorePasswordFilePath() {
        return this.storePassPath;
    }

    public String getKeyPasswordFilePath() {
        return this.keyPassPath;
    }

    @Override
    public KeyStore getKeyStore() {
        return this.ks;
    }

    public void setCertificateEntry(String certAlias, Certificate cert) throws KeyStoreException {
        try {
            this.ks.setCertificateEntry(certAlias, cert);
        }
        catch (KeyStoreException e) {
            this.logger.error(e.getMessage());
            throw e;
        }
    }

    public Certificate getCertificate(String certAlias) {
        try {
            return this.ks.getCertificate(certAlias);
        }
        catch (KeyStoreException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public void store() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        try {
            FileOutputStream keyStoreOStream = new FileOutputStream(this.keystoreFile);
            this.ks.store(keyStoreOStream, this.keystorePass.toCharArray());
            keyStoreOStream.close();
            keyStoreOStream = null;
            if (this.logger.messageEnabled()) {
                this.logger.message("Keystore saved in " + this.keystoreFile);
            }
        }
        catch (KeyStoreException e) {
            this.logger.error(e.getMessage());
            throw e;
        }
    }

    @Override
    public Certificate getCertificate(PublicKey publicKey) {
        String key = Base64.encode(publicKey.getEncoded());
        return (Certificate)this.keyTable.get(key);
    }

    @Override
    public boolean containsKey(String alias) {
        try {
            return this.ks.containsAlias(alias);
        }
        catch (KeyStoreException ksE) {
            this.logger.error("Unable to determine key alias presence", ksE);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecretKeyEntry(String alias, String password) throws KeyStoreException {
        SecretKeySpec keyspec = new SecretKeySpec(password.getBytes(StandardCharsets.UTF_8), "RAW");
        KeyStore.PasswordProtection keyStorePP = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
        try {
            if (this.ks.containsAlias(alias)) {
                this.ks.deleteEntry(alias);
            }
            KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(keyspec);
            this.ks.setEntry(alias, entry, keyStorePP);
        }
        finally {
            try {
                keyStorePP.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {}
        }
    }

    public String getSecret(String alias) throws KeyStoreException {
        KeyStore.PasswordProtection keyStorePP = new KeyStore.PasswordProtection(this.keystorePass.toCharArray());
        try {
            KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)this.ks.getEntry(alias, keyStorePP);
            String string = new String(entry.getSecretKey().getEncoded(), StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception e) {
            throw new KeyStoreException("Exception trying to fetch key with alias " + alias, e);
        }
        finally {
            try {
                keyStorePP.destroy();
            }
            catch (DestroyFailedException e) {
                throw new KeyStoreException("Destroy failed", e);
            }
        }
    }
}

