/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.security.crypto;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.forgerock.openam.shared.security.crypto.KeyPairProvider;

final class KeyPairProviderImpl
implements KeyPairProvider {
    private final Map<CacheKey, KeyPair> keyPairCache = new HashMap<CacheKey, KeyPair>();

    KeyPairProviderImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyPair getKeyPair(String algorithm, int keySize) {
        CacheKey cacheKey = new CacheKey(algorithm, keySize);
        KeyPair keyPair = this.keyPairCache.get(cacheKey);
        if (keyPair == null) {
            Map<CacheKey, KeyPair> map = this.keyPairCache;
            synchronized (map) {
                keyPair = this.keyPairCache.get(cacheKey);
                if (keyPair == null) {
                    keyPair = this.newKeyPair(algorithm, keySize);
                    this.keyPairCache.put(cacheKey, keyPair);
                }
            }
        }
        return keyPair;
    }

    private KeyPair newKeyPair(String algorithm, int keySize) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm);
            generator.initialize(keySize);
            return generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException nsaE) {
            throw new IllegalArgumentException("Unsupported key algorithm " + algorithm, nsaE);
        }
    }

    private static final class CacheKey {
        private final String algorithm;
        private final int keySize;

        CacheKey(String algorithm, int keySize) {
            this.algorithm = algorithm;
            this.keySize = keySize;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            return Objects.equals(this.keySize, cacheKey.keySize) && Objects.equals(this.algorithm, cacheKey.algorithm);
        }

        public int hashCode() {
            return Objects.hash(this.algorithm, this.keySize);
        }
    }
}

