/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.security.crypto;

import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.ConfigurableKey;
import com.sun.identity.shared.debug.Debug;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.SecretKeySpec;
import org.forgerock.openam.shared.security.crypto.PBKDF2KeyDerivation;
import org.forgerock.openam.utils.CipherProvider;
import org.forgerock.openam.utils.Providers;
import org.forgerock.util.Reject;
import org.forgerock.util.annotations.VisibleForTesting;

public class AESWrapEncryption
implements AMEncryption,
ConfigurableKey {
    private static final Debug DEBUG = Debug.getInstance("amSDK");
    private static final byte VERSION = 2;
    private static final int AESWRAP_BLOCK_SIZE = 8;
    private static final int CACHE_SIZE = Integer.getInteger("amCryptoCacheSize", 500);
    private static final String CIPHER_PROVIDER_ALGORITHM = Double.parseDouble(System.getProperty("java.specification.version")) >= 17.0 ? "AESWrapPad" : "AESWrap";
    private static final CipherProvider CIPHER_PROVIDER = Providers.cipherProvider(CIPHER_PROVIDER_ALGORITHM, null, CACHE_SIZE);
    private static final int KEY_SIZE = Integer.getInteger("org.forgerock.openam.encryption.key.size", 128);
    private final PBKDF2KeyDerivation keyDerivation;

    @VisibleForTesting
    AESWrapEncryption(PBKDF2KeyDerivation keyDerivation) {
        this.keyDerivation = keyDerivation;
    }

    public AESWrapEncryption() {
        this(new PBKDF2KeyDerivation());
    }

    @Override
    public void setPassword(String password) throws Exception {
        this.keyDerivation.setPassword(password);
    }

    @Override
    public byte[] encrypt(byte[] rawData) {
        PBEKey encryptionKey = this.keyDerivation.deriveSecretKey(KEY_SIZE);
        try {
            Cipher cipher = CIPHER_PROVIDER.getCipher();
            cipher.init(3, new SecretKeySpec(encryptionKey.getEncoded(), "AES"));
            byte[] encrypted = cipher.wrap(new SecretKeySpec(AESWrapEncryption.pkcs5pad(rawData), "RAW"));
            return AESWrapEncryption.formatEncryptedMessage(encryptionKey, encrypted);
        }
        catch (GeneralSecurityException e) {
            DEBUG.error("AESWrapEncryption: Failed to encrypt data", e);
            return null;
        }
    }

    @Override
    public byte[] decrypt(byte[] encData) {
        if (encData == null || encData.length < 2 || encData[0] != 2) {
            DEBUG.error("AESWrapEncryption: malformed input");
            return null;
        }
        int saltLen = encData[1] & 0xFF;
        if (saltLen < 0 || saltLen > encData.length - 2) {
            DEBUG.error("AESWrapEncryption: invalid salt length {}", saltLen);
            return null;
        }
        byte[] salt = Arrays.copyOfRange(encData, 2, saltLen + 2);
        PBEKey encryptionKey = this.keyDerivation.deriveSecretKey(KEY_SIZE, salt);
        byte[] data = Arrays.copyOfRange(encData, saltLen + 2, encData.length);
        try {
            Cipher cipher = CIPHER_PROVIDER.getCipher();
            cipher.init(4, new SecretKeySpec(encryptionKey.getEncoded(), "AES"));
            return AESWrapEncryption.pkcs5unpad(cipher.unwrap(data, "RAW", 3).getEncoded());
        }
        catch (GeneralSecurityException e) {
            DEBUG.error("AESWrapEncryption: Failed to decrypt data", e);
            return null;
        }
    }

    @VisibleForTesting
    static byte[] formatEncryptedMessage(PBEKey key, byte[] data) {
        byte[] salt = key.getSalt();
        if (salt.length > 255) {
            throw new IllegalStateException("Salt too large to be encoded");
        }
        ByteBuffer buffer = ByteBuffer.allocate(2 + salt.length + data.length).order(ByteOrder.BIG_ENDIAN);
        buffer.put((byte)2);
        buffer.put((byte)salt.length);
        buffer.put(salt);
        buffer.put(data);
        return buffer.array();
    }

    static byte[] pkcs5pad(byte[] data) {
        int len = data.length;
        int padding = 8 - len % 8;
        byte[] result = new byte[len + padding];
        System.arraycopy(data, 0, result, 0, data.length);
        Arrays.fill(result, len, len + padding, (byte)padding);
        return result;
    }

    static byte[] pkcs5unpad(byte[] data) throws BadPaddingException {
        Reject.ifNull((Object)data);
        int len = data.length;
        byte padding = data[len - 1];
        if (padding <= 0 || padding > 8) {
            throw new BadPaddingException("Invalid padding length: " + padding);
        }
        byte[] expectedPadding = new byte[padding];
        Arrays.fill(expectedPadding, padding);
        byte[] actualPadding = Arrays.copyOfRange(data, len - padding, len);
        if (!MessageDigest.isEqual(expectedPadding, actualPadding)) {
            throw new BadPaddingException("Invalid padding");
        }
        return Arrays.copyOfRange(data, 0, len - padding);
    }
}

