/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.monitoring;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.forgerock.openam.shared.monitoring.RateTimer;

public class RateWindow {
    private final RateTimer timer;
    private final int size;
    private final long sampleRate;
    private final ConcurrentSkipListMap<Long, AtomicLong> window = new ConcurrentSkipListMap();
    private final Comparator<AtomicLong> atomicLongComparator = new Comparator<AtomicLong>(){

        @Override
        public int compare(AtomicLong rate, AtomicLong rate2) {
            long y;
            long x = rate.get();
            return x > (y = rate2.get()) ? 1 : (x < y ? -1 : 0);
        }
    };

    public RateWindow(RateTimer timer, int size, long sampleRate) {
        this.timer = timer;
        this.size = size;
        this.sampleRate = sampleRate;
    }

    public void incrementForTimestamp(long timestamp) {
        long index = this.getIndexForTimestamp(timestamp);
        if (this.isWithinWindow(index)) {
            AtomicLong rate = this.window.get(index);
            if (rate == null) {
                this.fillInWindow(index - 1L);
                rate = new AtomicLong(0L);
                AtomicLong previousValue = this.window.putIfAbsent(index, rate);
                if (previousValue == null) {
                    this.window.headMap((Object)(this.window.lastKey() - (long)this.size), true).clear();
                } else {
                    rate = previousValue;
                }
            }
            rate.incrementAndGet();
        }
    }

    private void fillInWindow(long index) {
        if (!this.window.isEmpty()) {
            Long lastKey = this.window.lastKey();
            lastKey = lastKey + 1L;
            while (lastKey <= index) {
                this.window.putIfAbsent(lastKey, new AtomicLong(0L));
                Long l = lastKey;
                Long l2 = lastKey = Long.valueOf(lastKey + 1L);
            }
            this.window.headMap((Object)(this.window.lastKey() - (long)this.size), true).clear();
        }
    }

    public synchronized double getAverageRate() {
        if (this.window.isEmpty()) {
            return 0.0;
        }
        this.fillInWindow(this.getCurrentIndex());
        double averageRate = 0.0;
        for (Map.Entry<Long, AtomicLong> entry : this.window.entrySet()) {
            if (entry.getKey().equals(this.getCurrentIndex())) continue;
            averageRate += (double)entry.getValue().get();
        }
        return averageRate / (double)this.window.size();
    }

    public long getMinRate() {
        if (this.window.isEmpty()) {
            return 0L;
        }
        this.fillInWindow(this.getCurrentIndex());
        return Collections.min(this.window.values(), this.atomicLongComparator).get();
    }

    public long getMaxRate() {
        if (this.window.isEmpty()) {
            return 0L;
        }
        this.fillInWindow(this.getCurrentIndex());
        return Collections.max(this.window.values(), this.atomicLongComparator).get();
    }

    private long getIndexForTimestamp(long timestamp) {
        return timestamp / this.sampleRate;
    }

    private long getCurrentIndex() {
        return this.getIndexForTimestamp(this.timer.now());
    }

    private boolean isWithinWindow(long index) {
        return this.getCurrentIndex() - (long)this.size < index;
    }
}

