/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.concurrency;

import com.sun.identity.shared.debug.Debug;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.forgerock.util.Reject;
import org.forgerock.util.annotations.VisibleForTesting;
import org.forgerock.util.thread.listener.ShutdownListener;
import org.forgerock.util.thread.listener.ShutdownManager;

public class ThreadMonitor {
    private static final int DEFAULT_MAX_RECOVERY_DELAY = 2000;
    private static final int DEFAULT_RECOVERY_DELAY_DELTA = 5;
    private static final String DEBUG_HEADER = "ThreadMonitor: ";
    private final ExecutorService workPool;
    private final ShutdownManager shutdownManager;
    private final Debug debug;
    private int maxRecoveryDelayInMS = 2000;
    private int recoveryDelayDeltaInMS = 5;
    private int successiveFailingCounter = 0;

    @Inject
    public ThreadMonitor(ExecutorService workPool, ShutdownManager shutdownManager, @Named(value="amThreadManager") Debug debug) {
        this(workPool, shutdownManager, debug, 2000, 5);
    }

    @VisibleForTesting
    public ThreadMonitor(ExecutorService workPool, ShutdownManager shutdownManager, @Named(value="amThreadManager") Debug debug, int maxRecoveryDelayInMS, int recoveryDelayDeltaInMS) {
        this.workPool = workPool;
        this.shutdownManager = shutdownManager;
        this.debug = debug;
        this.maxRecoveryDelayInMS = maxRecoveryDelayInMS;
        this.recoveryDelayDeltaInMS = recoveryDelayDeltaInMS;
    }

    public void watchThread(final ExecutorService service, final Runnable runnable) {
        Reject.ifNull((Object[])new Object[]{service, runnable});
        this.workPool.submit(new WatchDog(new StartThread(){

            @Override
            public Future<?> start() {
                return service.submit(runnable);
            }

            @Override
            public String toString() {
                return "Executable: " + runnable.toString();
            }
        }));
    }

    public void watchScheduledThread(final ScheduledExecutorService scheduledService, final Runnable runnable, final long delay, final long duration, final TimeUnit timeUnit) {
        Reject.ifNull((Object[])new Object[]{scheduledService, runnable});
        this.workPool.submit(new WatchDog(new StartThread(){

            @Override
            public Future<?> start() {
                return scheduledService.scheduleAtFixedRate(runnable, delay, duration, timeUnit);
            }

            @Override
            public String toString() {
                return MessageFormat.format("ScheduledExecutable: {0} (start:{1} duration:{2} TimeUnit:{3}", runnable.toString(), delay, duration, timeUnit.toString());
            }
        }));
    }

    @VisibleForTesting
    public int getSuccessiveFailingCounter() {
        return this.successiveFailingCounter;
    }

    private void debug(String state, StartThread start) {
        if (this.debug.messageEnabled()) {
            this.debug.message(DEBUG_HEADER + state + ": " + start.toString());
        }
    }

    private static interface StartThread {
        public Future<?> start();

        public String toString();
    }

    private class WatchDog
    implements Runnable {
        private final StartThread startThread;
        private boolean complete = false;
        private Future<?> future;

        public WatchDog(StartThread startThread) {
            this.startThread = startThread;
            ThreadMonitor.this.shutdownManager.addShutdownListener(new ShutdownListener(){

                public void shutdown() {
                    WatchDog.this.cancel();
                }
            });
        }

        private synchronized void cancel() {
            this.setComplete(true);
            Future<?> future = this.getFuture();
            if (future != null && !future.isDone()) {
                ThreadMonitor.this.debug("Cancelling", this.startThread);
                future.cancel(true);
            }
        }

        private synchronized Future<?> getFuture() {
            return this.future;
        }

        private synchronized void setFuture(Future<?> future) {
            Reject.ifNull(future);
            this.future = future;
        }

        private synchronized void setComplete(boolean complete) {
            this.complete = complete;
            if (complete) {
                ThreadMonitor.this.successiveFailingCounter = 0;
            }
        }

        private synchronized boolean isComplete() {
            return this.complete;
        }

        @Override
        public void run() {
            while (!this.isComplete()) {
                if (ThreadMonitor.this.successiveFailingCounter > 0) {
                    try {
                        Thread.sleep(Math.min(ThreadMonitor.this.recoveryDelayDeltaInMS * (int)Math.pow(2.0, ThreadMonitor.this.successiveFailingCounter), ThreadMonitor.this.maxRecoveryDelayInMS));
                    }
                    catch (InterruptedException e) {
                        ThreadMonitor.this.debug.message("ThreadMonitor: interrupt detected, shutting down");
                        this.setComplete(true);
                        Thread.currentThread().interrupt();
                    }
                }
                ThreadMonitor.this.debug("Starting", this.startThread);
                this.setFuture(this.startThread.start());
                try {
                    this.setComplete(false);
                    this.getFuture().get();
                    this.setComplete(true);
                    ThreadMonitor.this.debug("Complete", this.startThread);
                }
                catch (InterruptedException e) {
                    ThreadMonitor.this.debug("interrupt detected, shutting down", this.startThread);
                    this.setComplete(true);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    ThreadMonitor.this.successiveFailingCounter++;
                    ThreadMonitor.this.debug.error("ThreadMonitor: Thread WatchDog detected error, restarting", e);
                }
                finally {
                    ThreadMonitor.this.debug("Complete:" + this.isComplete(), this.startThread);
                }
            }
            ThreadMonitor.this.debug("Exited", this.startThread);
        }
    }
}

