/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.shared.concurrency;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.forgerock.openam.shared.concurrency.ResizableSemaphore;
import org.forgerock.util.Reject;

public class ResizableLinkedBlockingQueue<E>
extends LinkedBlockingQueue<E> {
    private int queueSize;
    private final ResizableSemaphore availablePlaces;

    public ResizableLinkedBlockingQueue() {
        this.queueSize = Integer.MAX_VALUE;
        this.availablePlaces = new ResizableSemaphore(this.queueSize, true);
    }

    public ResizableLinkedBlockingQueue(Collection<? extends E> c) {
        super(c);
        this.queueSize = Integer.MAX_VALUE;
        this.availablePlaces = new ResizableSemaphore(this.queueSize, true);
    }

    public ResizableLinkedBlockingQueue(int initialCapacity) {
        this.queueSize = initialCapacity;
        this.availablePlaces = new ResizableSemaphore(initialCapacity, true);
    }

    public synchronized void resizeQueue(int newSize) throws IllegalArgumentException {
        if (newSize < 0) {
            throw new IllegalArgumentException("Cannot set queue size to a value below zero.");
        }
        if (newSize < this.queueSize) {
            int difference = this.queueSize - newSize;
            this.availablePlaces.reducePermits(difference);
        } else if (newSize > this.queueSize) {
            int difference = newSize - this.queueSize;
            this.availablePlaces.increasePermits(difference);
        }
        this.queueSize = newSize;
    }

    public int getMaximumQueueSize() {
        return this.queueSize;
    }

    @Override
    public boolean offer(E e) {
        boolean returnValue;
        Reject.ifNull(e, (String)"Element to offer cannot be null.");
        if (this.availablePlaces.tryAcquire()) {
            if (super.offer(e)) {
                returnValue = true;
            } else {
                returnValue = false;
                this.availablePlaces.release();
            }
        } else {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        boolean returnValue;
        Reject.ifNull(e, (String)"Element to offer cannot be null.");
        if (this.availablePlaces.tryAcquire(timeout, unit)) {
            if (super.offer(e)) {
                returnValue = true;
            } else {
                returnValue = false;
                this.availablePlaces.release();
            }
        } else {
            returnValue = false;
        }
        return returnValue;
    }

    @Override
    public E poll() {
        Object returnValue = super.poll();
        if (returnValue != null) {
            this.availablePlaces.release();
        }
        return returnValue;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object resultValue = super.poll(timeout, unit);
        if (resultValue != null) {
            this.availablePlaces.release();
        }
        return resultValue;
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.availablePlaces.acquire();
        super.put(e);
    }

    @Override
    public int remainingCapacity() {
        return this.availablePlaces.availablePermits();
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.availablePlaces.release();
            return true;
        }
        return false;
    }

    @Override
    public E take() throws InterruptedException {
        Object result = super.take();
        this.availablePlaces.release();
        return result;
    }
}

