/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.keystore;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import org.forgerock.security.keystore.KeyStoreBuilder;
import org.forgerock.security.keystore.KeyStoreType;

public class KeyStoreConfig {
    private String keyStorePasswordFile;
    private String keyPasswordFile;
    private String keyStoreType;
    private String keyStoreFile;
    private String providerClass;
    private String providerArg;

    public String getKeyStorePasswordFile() {
        return this.keyStorePasswordFile;
    }

    public void setKeyStorePasswordFile(String keyStorePasswordFile) {
        this.keyStorePasswordFile = keyStorePasswordFile;
    }

    public String getKeyPasswordFile() {
        return this.keyPasswordFile;
    }

    public void setKeyPasswordFile(String keyPasswordFile) {
        this.keyPasswordFile = keyPasswordFile;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getProviderClass() {
        return this.providerClass;
    }

    public void setProviderClass(String providerClass) {
        this.providerClass = providerClass;
    }

    public String getProviderArg() {
        return this.providerArg;
    }

    public void setProviderArg(String providerArg) {
        this.providerArg = providerArg;
    }

    @JsonIgnore
    public char[] getKeyStorePassword() throws IOException {
        return new String(Files.readAllBytes(Paths.get(this.getKeyStorePasswordFile(), new String[0])), StandardCharsets.UTF_8).toCharArray();
    }

    @JsonIgnore
    public char[] getKeyPassword() throws IOException {
        return new String(Files.readAllBytes(Paths.get(this.getKeyPasswordFile(), new String[0])), StandardCharsets.UTF_8).toCharArray();
    }

    public KeyStore loadKeyStore() throws KeyStoreException {
        KeyStore ks = null;
        try {
            KeyStoreBuilder builder = new KeyStoreBuilder();
            ks = builder.withKeyStoreFile(this.getKeyStoreFile()).withKeyStoreType(KeyStoreType.JCEKS).withPassword(this.getKeyPassword()).build();
        }
        catch (IOException e) {
            throw new KeyStoreException("Could not initialize the Keystore", e);
        }
        return ks;
    }
}

