/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.diffs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;

public class Stat {
    private static final String MODIFIED = "Status: Locally Modified";
    private static final String ADDED = "Status: Locally Added";
    private static final String REMOVED = "Status: Locally Removed";
    private static final String TAG_MODIFIED = "M";
    private static final String TAG_ADDED = "A";
    private static final String TAG_REMOVED = "R";
    private static final String TEMPLATE = "{0} {1}\n";

    private Stat() {
    }

    public static void discover(String filename) throws IOException {
        int fileIdx = filename.lastIndexOf(47);
        String baseDir = fileIdx == -1 ? "./" : filename.substring(0, fileIdx + 1);
        String content = Stat.getFileContent(filename);
        StringBuffer buff = new StringBuffer();
        Stat.discover(content, ADDED, TAG_ADDED, buff);
        Stat.discover(content, REMOVED, TAG_REMOVED, buff);
        Stat.discover(content, MODIFIED, TAG_MODIFIED, buff);
        Stat.writeToFile(baseDir + "stat", buff.toString());
    }

    private static void discover(String content, String tag, String marker, StringBuffer buff) {
        int idx = content.indexOf(tag);
        while (idx != -1) {
            int idx2 = content.lastIndexOf("File: ", idx);
            String fileName = null;
            if (idx2 != -1) {
                int j;
                int i;
                fileName = content.substring(idx2, idx);
                if (!tag.equals(ADDED) && (i = content.indexOf("Repository revision", idx)) != -1 && (i = content.indexOf("/cvs/", i)) != -1 && (j = content.indexOf(",v", i)) != -1) {
                    fileName = content.substring(i + 5, j);
                }
                Object[] params = new Object[]{marker, fileName};
                buff.append(MessageFormat.format(TEMPLATE, params));
            }
            idx = content.indexOf(tag, idx + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(String filename) throws IOException {
        StringBuffer sb = new StringBuffer();
        File fileHandle = new File(filename);
        try (FileReader in = null;){
            in = new FileReader(filename);
            BufferedReader buff = new BufferedReader(in);
            Object curFileName = null;
            String line = buff.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = buff.readLine();
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String filename, String content) throws IOException {
        if (filename != null) {
            File fileHandle = new File(filename);
            try (FileWriter out = null;){
                out = new FileWriter(filename);
                out.write(content);
            }
        }
    }

    public static void main(String[] args) {
        try {
            Stat.discover(args[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

