/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.xml;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.forgerock.openam.utils.PerThreadCache;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathAPI {
    private static final int CACHE_SIZE = SystemPropertiesManager.getAsInt("org.forgerock.openam.utils.xml.xpathfactory.cache.size", 500);
    private static final PerThreadCache<XPathFactory, RuntimeException> xpathFactoryCache = new PerThreadCache<XPathFactory, RuntimeException>(CACHE_SIZE){

        @Override
        protected XPathFactory initialValue() {
            return XPathFactory.newInstance();
        }
    };

    private XPathAPI() {
    }

    public static Node selectSingleNode(Node doc, String str) throws XPathException {
        return XPathAPI.selectSingleNode(doc, str, doc);
    }

    public static Node selectSingleNode(Node doc, String str, Node nsNode) throws XPathException {
        SimpleNamespaceContext nsctx = new SimpleNamespaceContext(nsNode);
        return XPathAPI.selectSingleNode(doc, str, nsctx);
    }

    public static Node selectSingleNode(Node doc, String str, NamespaceContext nsctx) throws XPathException {
        NodeList nl = XPathAPI.selectNodeList(doc, str, nsctx);
        if (nl.getLength() == 0) {
            return null;
        }
        return nl.item(0);
    }

    public static NodeList selectNodeList(Node doc, String str) throws XPathException {
        return XPathAPI.selectNodeList(doc, str, doc);
    }

    public static NodeList selectNodeList(Node doc, String str, Node nsNode) throws XPathException {
        SimpleNamespaceContext nsctx = new SimpleNamespaceContext(nsNode);
        return XPathAPI.selectNodeList(doc, str, nsctx);
    }

    public static NodeList selectNodeList(Node doc, String str, NamespaceContext nsctx) throws XPathException {
        XPathFactory xpf = xpathFactoryCache.getInstanceForCurrentThread();
        XPath xpath = xpf.newXPath();
        xpath.setNamespaceContext(nsctx);
        XPathExpression expr = xpath.compile(str);
        return (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
    }

    static class SimpleNamespaceContext
    implements NamespaceContext {
        private Map<String, String> pfxmap = new HashMap<String, String>();
        private Map<String, List<String>> uri2pfxmap = new HashMap<String, List<String>>();

        public SimpleNamespaceContext(Node node) {
            this.pfxmap.put("xml", "http://www.w3.org/XML/1998/namespace");
            this.pfxmap.put("xmlns", "http://www.w3.org/2000/xmlns/");
            this.addNamespaces(node);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException();
            }
            if (this.pfxmap.containsKey(prefix)) {
                return this.pfxmap.get(prefix);
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceUri) {
            if (namespaceUri == null) {
                throw new IllegalArgumentException();
            }
            for (Map.Entry<String, String> entry : this.pfxmap.entrySet()) {
                if (!entry.getValue().equals(namespaceUri)) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceUri) {
            List<String> prefixes;
            if ("http://www.w3.org/XML/1998/namespace".equals(namespaceUri)) {
                prefixes = Collections.singletonList("xml");
            } else if ("http://www.w3.org/2000/xmlns/".equals(namespaceUri)) {
                prefixes = Collections.singletonList("xmlns");
            } else {
                prefixes = this.uri2pfxmap.get(namespaceUri);
                if (prefixes == null) {
                    prefixes = Collections.EMPTY_LIST;
                }
            }
            return prefixes.iterator();
        }

        private void addNamespaces(Node element) {
            if (element.getParentNode() != null) {
                this.addNamespaces(element.getParentNode());
            }
            if (element.getNodeType() == 9) {
                element = ((Document)element).getDocumentElement();
            }
            if (element instanceof Element) {
                Element el = (Element)element;
                NamedNodeMap nmap = el.getAttributes();
                for (int x = 0; x < nmap.getLength(); ++x) {
                    Attr attr = (Attr)nmap.item(x);
                    if (!"xmlns".equals(attr.getPrefix())) continue;
                    String name = attr.getLocalName();
                    String nsUri = attr.getValue();
                    this.pfxmap.put(name, nsUri);
                    List<String> list = this.uri2pfxmap.get(nsUri);
                    if (list == null) {
                        list = new ArrayList<String>();
                        this.uri2pfxmap.put(nsUri, list);
                    }
                    list.add(name);
                }
            }
        }
    }
}

