/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.jaxrpc;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.StringTokenizer;

public class JAXRPCHelper {
    private static final String JAXRPC_URL = "com.sun.identity.jaxrpc.url";
    private static final String JAXRPC_SERVICE = "jaxrpc";
    public static final String SMS_SERVICE = "SMSObjectIF";
    protected static String validRemoteURL;
    protected static boolean serverFailed;
    protected static Debug debug;

    public static String getValidURL(String serviceName) throws RemoteException {
        if (serviceName == null) {
            throw new RemoteException("invalid-service-name");
        }
        if (serverFailed) {
            validRemoteURL = JAXRPCHelper.getValidServerURL();
        }
        if (validRemoteURL == null) {
            if (debug.warningEnabled()) {
                debug.warning("JAXRPCHelper: No vaild server found");
            }
            throw new RemoteException("no-server-found");
        }
        return validRemoteURL + serviceName;
    }

    public static void serverFailed(String serviceName) {
        if (validRemoteURL == null) {
            if (debug.warningEnabled()) {
                debug.warning("JAXRPCHelper: No valid server found");
            }
            serverFailed = true;
        } else if (serviceName.startsWith(validRemoteURL)) {
            serverFailed = true;
        }
    }

    protected static String getValidServerURL() {
        block10: {
            block9: {
                String servers = SystemPropertiesManager.get(JAXRPC_URL);
                if (servers == null) break block9;
                StringTokenizer st = new StringTokenizer(servers, ",");
                while (st.hasMoreTokens()) {
                    String surl = st.nextToken();
                    if (!surl.endsWith("/")) {
                        surl = surl + "/";
                    }
                    if (!JAXRPCHelper.isServerValid(surl)) continue;
                    return surl;
                }
                break block10;
            }
            Collection serverList = null;
            try {
                serverList = SystemPropertiesManager.getSystemProperties().getServiceAllURLs(JAXRPC_SERVICE);
            }
            catch (Exception e) {
                if (debug.warningEnabled()) {
                    debug.warning("JAXRPCHelper:getValidServerURL: Unable to get platform server", e);
                }
                return null;
            }
            if (serverList == null) break block10;
            for (URL weburl : serverList) {
                try {
                    String surl = weburl.toString();
                    if (!surl.endsWith("/")) {
                        surl = surl + "/";
                    }
                    if (!JAXRPCHelper.isServerValid(surl)) continue;
                    return surl;
                }
                catch (Exception e) {
                    debug.warning("JAXRPCHelper:getValidServerURL", e);
                }
            }
        }
        return null;
    }

    protected static boolean isServerValid(String url) {
        try {
            if (!url.endsWith(SMS_SERVICE)) {
                url = url + SMS_SERVICE;
            }
            SOAPClient client = new SOAPClient();
            client.setURL(url);
            client.send(client.encodeMessage("checkForLocal", null), null, null);
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("JAXRPCHelper: Connection to URL: " + url + " failed", e);
            }
            return false;
        }
        return true;
    }

    static {
        serverFailed = true;
        debug = SOAPClient.debug;
    }
}

