/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.encode;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.forgerock.openam.utils.Time;

public class CookieUtils {
    static boolean secureCookie = SystemPropertiesManager.get("com.iplanet.am.cookie.secure") != null && SystemPropertiesManager.get("com.iplanet.am.cookie.secure").equalsIgnoreCase("true");
    static boolean cookieHttpOnly = SystemPropertiesManager.get("com.sun.identity.cookie.httponly") != null && SystemPropertiesManager.get("com.sun.identity.cookie.httponly").equalsIgnoreCase("true");
    static String cookieSameSite = SystemPropertiesManager.get("org.openidentityplatform.openam.cookie.samesite");
    static boolean cookieEncoding = SystemPropertiesManager.get("com.iplanet.am.cookie.encode") != null && SystemPropertiesManager.get("com.iplanet.am.cookie.encode").equalsIgnoreCase("true");
    static String amCookieName = SystemPropertiesManager.get("com.iplanet.am.cookie.name");
    static String amPCookieName = SystemPropertiesManager.get("com.iplanet.am.pcookie.name");
    static String cdssoCookiedomain = SystemPropertiesManager.get("com.iplanet.services.cdsso.cookiedomain");
    static String fedCookieName = SystemPropertiesManager.get("com.sun.identity.federation.fedCookieName");
    private static Set cookieDomains = null;
    private static int defAge = -1;
    static Debug debug = Debug.getInstance("amCookieUtils");
    private static final Method setHttpOnlyMethod;

    public static String getAmCookieName() {
        return amCookieName;
    }

    public static String getAmPCookieName() {
        return amPCookieName;
    }

    public static Set getCdssoCookiedomain() {
        if (cookieDomains != null) {
            return cookieDomains;
        }
        HashSet<String> cookieDomains = new HashSet<String>();
        if (cdssoCookiedomain == null || cdssoCookiedomain.length() < 1) {
            return Collections.EMPTY_SET;
        }
        StringTokenizer st = new StringTokenizer(cdssoCookiedomain, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            cookieDomains.add(token);
        }
        return cookieDomains.isEmpty() ? Collections.EMPTY_SET : cookieDomains;
    }

    public static String getFedCookieName() {
        return fedCookieName;
    }

    public static boolean isCookieSecure() {
        return secureCookie;
    }

    public static boolean isCookieHttpOnly() {
        return cookieHttpOnly;
    }

    public static String getCookieSameSite() {
        return cookieSameSite;
    }

    public static String getCookieValueFromReq(HttpServletRequest req, String name) {
        String cookieValue = null;
        Cookie cookie = CookieUtils.getCookieFromReq(req, name);
        if (cookie != null) {
            cookieValue = CookieUtils.getCookieValue(cookie);
        } else {
            debug.message("No Cookie is in the request");
        }
        return cookieValue;
    }

    public static Cookie getCookieFromReq(HttpServletRequest req, String name) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int nCookie = 0; nCookie < cookies.length; ++nCookie) {
                if (!cookies[nCookie].getName().equalsIgnoreCase(name)) continue;
                return cookies[nCookie];
            }
        }
        return null;
    }

    public static String getCookieValue(Cookie cookie) {
        String cookieValue = CookieUtils.checkDoubleQuote(cookie.getValue());
        if (cookieValue != null && cookieEncoding) {
            return URLEncDec.decode(cookieValue);
        }
        return cookieValue;
    }

    public static Cookie[] getCookieArrayFromReq(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (!cookieEncoding) {
            return cookies;
        }
        if (cookies != null) {
            for (int nCookie = 0; nCookie < cookies.length; ++nCookie) {
                String cookieValue = CookieUtils.checkDoubleQuote(cookies[nCookie].getValue());
                if (cookieValue == null) continue;
                cookies[nCookie].setValue(URLEncDec.decode(cookieValue));
            }
        }
        return cookies;
    }

    public static Map<String, String> getRequestCookies(HttpServletRequest request) {
        Cookie[] cookies;
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        if (request != null && (cookies = request.getCookies()) != null && cookies.length > 0) {
            for (Cookie nextCookie : cookies) {
                String name = nextCookie.getName();
                String value = nextCookie.getValue();
                cookieMap.put(name, value);
            }
        }
        return cookieMap;
    }

    public static Cookie newCookie(String name, String value) {
        return CookieUtils.newCookie(name, value, defAge, null, null);
    }

    public static Cookie newCookie(String name, String value, int maxAge) {
        return CookieUtils.newCookie(name, value, maxAge, null, null);
    }

    public static Cookie newCookie(String name, String value, String path) {
        return CookieUtils.newCookie(name, value, defAge, path, null);
    }

    public static Cookie newCookie(String name, String value, String path, String domain) {
        return CookieUtils.newCookie(name, value, defAge, path, domain);
    }

    public static Cookie newCookie(String name, String value, int maxAge, String path, String domain) {
        Cookie cookie = null;
        cookie = cookieEncoding && value != null ? new Cookie(name, URLEncDec.encode(value)) : new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        if (path != null && path.length() > 0) {
            cookie.setPath(path);
        } else {
            cookie.setPath("/");
        }
        if (domain != null && domain.length() > 0) {
            cookie.setDomain(domain);
        }
        cookie.setSecure(CookieUtils.isCookieSecure());
        return cookie;
    }

    public static String checkDoubleQuote(String cookie) {
        String double_quote = "\"";
        if (cookie != null && cookie.startsWith(double_quote) && cookie.endsWith(double_quote)) {
            int last = cookie.length() - 1;
            cookie = cookie.substring(1, last);
        }
        return cookie;
    }

    public static void addCookieToResponse(HttpServletResponse response, Cookie cookie) {
        int age;
        if (response == null || cookie == null) {
            return;
        }
        if (!CookieUtils.isCookieHttpOnly() && CookieUtils.getCookieSameSite() == null) {
            response.addCookie(cookie);
            return;
        }
        if (setHttpOnlyMethod != null && CookieUtils.getCookieSameSite() == null) {
            try {
                setHttpOnlyMethod.invoke((Object)cookie, true);
                response.addCookie(cookie);
                return;
            }
            catch (IllegalAccessException iae) {
                debug.warning("IllegalAccessException while trying to add HttpOnly cookie: " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                debug.error("An error occurred while trying to add HttpOnly cookie", ite);
            }
        }
        StringBuilder sb = new StringBuilder(150);
        sb.append(cookie.getName()).append("=").append(cookie.getValue());
        String path = cookie.getPath();
        if (path != null && path.length() > 0) {
            sb.append(";path=").append(path);
        } else {
            sb.append(";path=/");
        }
        String domain = cookie.getDomain();
        if (domain != null && domain.length() > 0) {
            sb.append(";domain=").append(domain);
        }
        if ((age = cookie.getMaxAge()) > -1) {
            Date date = new Date(Time.currentTimeMillis() + (long)age * 1000L);
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.UK);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            sb.append(";max-age=").append(age);
            sb.append(";Expires=").append(sdf.format(date));
        }
        if (CookieUtils.isCookieSecure() || cookie.getSecure()) {
            sb.append(";secure");
        }
        if (CookieUtils.isCookieHttpOnly()) {
            sb.append(";httponly");
        }
        if (CookieUtils.getCookieSameSite() != null) {
            sb.append(";SameSite=").append(CookieUtils.getCookieSameSite());
        }
        if (debug.messageEnabled()) {
            debug.message("CookieUtils:addCookieToResponse adds " + sb);
        }
        response.addHeader("Set-Cookie", sb.toString());
    }

    public static Set<String> getMatchingCookieDomains(HttpServletRequest request, Collection<String> cookieDomains) {
        HashSet<String> processedCookieDomains = new HashSet<String>();
        for (String cookieDomain : cookieDomains) {
            processedCookieDomains.add(cookieDomain.replaceFirst("^\\.", ""));
        }
        if (SystemPropertiesManager.getAsBoolean("com.sun.identity.authentication.setCookieToAllDomains", true)) {
            return new HashSet<String>(processedCookieDomains);
        }
        String host = request.getServerName();
        HashSet<String> domains = new HashSet<String>();
        for (String domain : processedCookieDomains) {
            if (domain == null || !StringUtils.endsWithIgnoreCase((String)host, (String)domain)) continue;
            domains.add(domain);
        }
        return domains;
    }

    static {
        Method method = null;
        try {
            method = Cookie.class.getMethod("setHttpOnly", Boolean.TYPE);
        }
        catch (NoSuchMethodException nsme) {
            debug.message("This is not a Java EE 6+ container, Cookie#setHttpOnly(boolean) is not available");
        }
        setHttpOnlyMethod = method;
    }
}

