/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.debug.impl;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.DebugConstants;
import com.sun.identity.shared.debug.DebugLevel;
import com.sun.identity.shared.debug.IDebug;
import com.sun.identity.shared.debug.file.DebugFile;
import com.sun.identity.shared.debug.file.DebugFileProvider;
import com.sun.identity.shared.debug.file.impl.StdDebugFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentSkipListMap;
import org.forgerock.openam.audit.context.AuditRequestContext;
import org.forgerock.openam.utils.IOUtils;
import org.forgerock.openam.utils.StringUtils;
import org.forgerock.openam.utils.Time;

public class DebugImpl
implements IDebug {
    static final Map<String, String> INSTANCE_NAMES = new ConcurrentSkipListMap<String, String>(new WildcardComparator());
    private static final int DIR_ISSUE_ERROR_INTERVAL_IN_MS = 60000;
    private static final boolean SERVER_MODE;
    private static volatile long lastDirectoryIssue;
    private final String debugName;
    private boolean mergeAllMode = false;
    private DebugLevel debugLevel = DebugLevel.ON;
    private DebugFileProvider debugFileProvider;
    private DebugFile debugFile = null;
    private DebugFile stdoutDebugFile;

    public DebugImpl(String debugName, DebugFileProvider debugFileProvider) {
        this.debugName = debugName;
        if (SystemPropertiesManager.get("com.iplanet.services.debug.level") != null) {
            this.setDebug(SystemPropertiesManager.get("com.iplanet.services.debug.level"));
        } else {
            this.setDebug(DebugLevel.ON);
        }
        this.debugFileProvider = debugFileProvider;
        this.stdoutDebugFile = debugFileProvider.getStdOutDebugFile();
        String mf = SystemPropertiesManager.get("com.sun.services.debug.mergeall");
        this.mergeAllMode = "on".equals(mf);
    }

    @Override
    public String getName() {
        return this.debugName;
    }

    @Override
    public int getState() {
        return this.debugLevel.getLevel();
    }

    @Override
    public void setDebug(int level) {
        try {
            this.setDebug(DebugLevel.fromLevel(level));
        }
        catch (IllegalArgumentException e) {
            StdDebugFile.printError(DebugImpl.class.getSimpleName(), e.getMessage(), e);
        }
    }

    @Override
    public void setDebug(String strDebugLevel) {
        try {
            this.setDebug(DebugLevel.fromName(strDebugLevel));
        }
        catch (IllegalArgumentException e) {
            StdDebugFile.printError(DebugImpl.class.getSimpleName(), e.getMessage(), e);
        }
    }

    public void setDebug(DebugLevel debugLevel) {
        this.debugLevel = debugLevel;
    }

    @Override
    public void resetDebug(String mf) {
        this.mergeAllMode = "on".equals(mf);
        this.setDebug(SystemPropertiesManager.get("com.iplanet.services.debug.level"));
        this.debugFile = null;
    }

    @Override
    public boolean messageEnabled() {
        return this.debugLevel.compareLevel(DebugLevel.MESSAGE) >= 0;
    }

    @Override
    public boolean warningEnabled() {
        return this.debugLevel.compareLevel(DebugLevel.WARNING) >= 0;
    }

    @Override
    public boolean errorEnabled() {
        return this.debugLevel.compareLevel(DebugLevel.ERROR) >= 0;
    }

    @Override
    public void message(String message, Throwable th) {
        if (this.messageEnabled()) {
            this.record(message, th);
        }
    }

    @Override
    public void warning(String message, Throwable th) {
        if (this.warningEnabled()) {
            this.record("WARNING: " + message, th);
        }
    }

    @Override
    public void error(String message, Throwable th) {
        if (this.errorEnabled()) {
            this.record("ERROR: " + message, th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void record(String msg, Throwable th) {
        String dateFormatted;
        StringBuilder prefix = new StringBuilder();
        SimpleDateFormat simpleDateFormat = DebugConstants.DEBUG_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            dateFormatted = DebugConstants.DEBUG_DATE_FORMAT.format(Time.newDate());
        }
        prefix.append(this.debugName).append(":").append(dateFormatted).append(": ").append(Thread.currentThread().toString()).append(": TransactionId[").append(this.getAuditTransactionId()).append("]");
        this.writeIt(prefix.toString(), msg, th);
    }

    private String getAuditTransactionId() {
        if (SERVER_MODE) {
            return AuditRequestContext.getTransactionIdValue();
        }
        return "unknown";
    }

    private void writeIt(String prefix, String msg, Throwable th) {
        if (this.debugFile == null) {
            String debugFileName = this.resolveDebugFileName();
            this.debugFile = this.debugFileProvider.getInstance(debugFileName);
        }
        try {
            if (this.debugLevel == DebugLevel.ON) {
                this.stdoutDebugFile.writeIt(prefix, msg, th);
            } else {
                try {
                    this.debugFile.writeIt(prefix, msg, th);
                }
                catch (IOException e) {
                    if (lastDirectoryIssue + 60000L < Time.currentTimeMillis()) {
                        lastDirectoryIssue = Time.currentTimeMillis();
                        this.stdoutDebugFile.writeIt(prefix, "Debug file can't be written : " + e.getMessage(), null);
                    }
                    this.stdoutDebugFile.writeIt(prefix, msg, th);
                }
            }
        }
        catch (IOException ioex) {
            StdDebugFile.printError(DebugImpl.class.getSimpleName(), ioex.getMessage(), ioex);
        }
    }

    private String resolveDebugFileName() {
        if (this.mergeAllMode) {
            return "debug.out";
        }
        String nm = INSTANCE_NAMES.get(this.debugName);
        if (nm != null) {
            return nm;
        }
        return this.debugName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initProperties() {
        InputStream is = null;
        try {
            is = DebugImpl.class.getResourceAsStream("/debugfiles.properties");
            if (is == null && SystemPropertiesManager.get("com.iplanet.services.debug.filesmap") != null) {
                is = DebugImpl.class.getResourceAsStream(SystemPropertiesManager.get("com.iplanet.services.debug.filesmap"));
            }
            Properties fileNames = new Properties();
            fileNames.load(is);
            INSTANCE_NAMES.clear();
            for (Map.Entry<Object, Object> entry : fileNames.entrySet()) {
                INSTANCE_NAMES.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (Exception ex) {
            StdDebugFile.printError(DebugImpl.class.getSimpleName(), "Can't read debug files map. '. Please check the configuration file '/debugfiles.properties'.", ex);
        }
        finally {
            IOUtils.closeIfNotNull((Closeable)is);
        }
    }

    static {
        DebugImpl.initProperties();
        SERVER_MODE = SystemPropertiesManager.getAsBoolean("com.iplanet.am.serverMode");
        lastDirectoryIssue = 0L;
    }

    private static final class WildcardComparator
    implements Comparator<String> {
        private WildcardComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return this.wildCardMatch(s1, s2) ? 0 : this.stringCompare(s1, s2);
        }

        private int stringCompare(String s1, String s2) {
            if (s1 == null || s2 == null) {
                return s1 == null ? (s2 == null ? 0 : -1) : 1;
            }
            return s1.compareTo(s2);
        }

        private boolean wildCardMatch(String value, String pattern) {
            return StringUtils.isNotEmpty(value) && StringUtils.isNotEmpty(pattern) && pattern.endsWith("*") && value.startsWith(pattern.substring(0, pattern.length() - 1));
        }
    }
}

