/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.debug.file.impl;

import com.sun.identity.shared.debug.file.DebugFile;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import org.forgerock.openam.utils.Time;

public class StdDebugFile
implements DebugFile {
    private static final StdDebugFile INSTANCE = new StdDebugFile();
    private PrintWriter stdoutWriter = new PrintWriter(System.out, true);

    private StdDebugFile() {
    }

    public static StdDebugFile getInstance() {
        return INSTANCE;
    }

    @Override
    public void writeIt(String prefix, String msg, Throwable th) throws IOException {
        StringBuilder buf = new StringBuilder(prefix);
        buf.append('\n');
        buf.append(msg);
        if (th != null) {
            buf.append('\n');
            StringWriter stBuf = new StringWriter(300);
            PrintWriter stackStream = new PrintWriter(stBuf);
            th.printStackTrace(stackStream);
            stackStream.flush();
            buf.append(stBuf.toString());
        }
        this.stdoutWriter.println(buf.toString());
    }

    public static void printError(String debugName, String message, Throwable ex) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss:SSS a zzz");
        String prefix = debugName + ":" + dateFormat.format(Time.newDate()) + ": " + Thread.currentThread().toString() + "\n";
        System.err.println(prefix + message);
        if (ex != null) {
            ex.printStackTrace(System.err);
        }
    }
}

