/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.debug.file.impl;

import com.sun.identity.shared.debug.file.DebugConfiguration;
import com.sun.identity.shared.debug.file.DebugFile;
import com.sun.identity.shared.debug.file.DebugFileProvider;
import com.sun.identity.shared.debug.file.impl.DebugConfigurationFromProperties;
import com.sun.identity.shared.debug.file.impl.DebugFileImpl;
import com.sun.identity.shared.debug.file.impl.DefaultDebugConfiguration;
import com.sun.identity.shared.debug.file.impl.InvalidDebugConfigurationException;
import com.sun.identity.shared.debug.file.impl.StdDebugFile;
import java.util.HashMap;
import java.util.Map;

public class DebugFileProviderImpl
implements DebugFileProvider {
    private Map<String, DebugFile> debugMap = new HashMap<String, DebugFile>();
    private DebugConfiguration configuration;

    public DebugFileProviderImpl() {
        try {
            this.configuration = new DebugConfigurationFromProperties("/debugconfig.properties");
        }
        catch (InvalidDebugConfigurationException e) {
            StdDebugFile.printError("DebugConfiguration", "'/debugconfig.properties' isn't valid, the default configuration will be used instead: " + e.getMessage(), null);
            this.configuration = DefaultDebugConfiguration.getInstance();
        }
    }

    @Override
    public synchronized DebugFile getInstance(String debugName) {
        DebugFile debugFile = this.debugMap.get(debugName);
        if (debugFile == null) {
            debugFile = new DebugFileImpl(this.configuration, debugName);
            this.debugMap.put(debugName, debugFile);
        }
        return debugFile;
    }

    @Override
    public DebugFile getStdOutDebugFile() {
        return StdDebugFile.getInstance();
    }
}

