/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.debug.file.impl;

import com.sun.identity.shared.debug.file.DebugConfiguration;
import com.sun.identity.shared.debug.file.impl.InvalidDebugConfigurationException;
import com.sun.identity.shared.debug.file.impl.StdDebugFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import org.forgerock.openam.utils.IOUtils;
import org.forgerock.openam.utils.StringUtils;
import org.forgerock.openam.utils.Time;

public class DebugConfigurationFromProperties
implements DebugConfiguration {
    private String debugPrefix = "";
    private String debugSuffix = "";
    private int rotationInterval = -1;
    private long maxFileSizeInByte = -1L;

    public DebugConfigurationFromProperties(String debugFilePropertiesPath) throws InvalidDebugConfigurationException {
        InputStream is = null;
        try {
            String rotation;
            is = DebugConfigurationFromProperties.class.getResourceAsStream(debugFilePropertiesPath);
            if (is == null) {
                throw new InvalidDebugConfigurationException("Can't find the configuration file '" + debugFilePropertiesPath + "'.");
            }
            Properties rotationConfig = new Properties();
            rotationConfig.load(is);
            this.debugPrefix = rotationConfig.getProperty("org.forgerock.openam.debug.prefix");
            this.debugSuffix = rotationConfig.getProperty("org.forgerock.openam.debug.suffix");
            String maxFileSizedInMb = rotationConfig.getProperty("org.forgerock.openam.debug.rotation.maxsize");
            if (!StringUtils.isEmpty(maxFileSizedInMb)) {
                try {
                    this.maxFileSizeInByte = Integer.parseInt(maxFileSizedInMb);
                    this.maxFileSizeInByte <<= 20;
                }
                catch (NumberFormatException e) {
                    String message = "The 'org.forgerock.openam.debug.rotation.maxsize' value : " + maxFileSizedInMb + "' cannot be parsed. Please check the configuration file '" + "/debugconfig.properties" + "'.";
                    StdDebugFile.printError(DebugConfigurationFromProperties.class.getSimpleName(), message, e);
                }
            }
            if (!StringUtils.isEmpty(rotation = rotationConfig.getProperty("org.forgerock.openam.debug.rotation"))) {
                try {
                    this.rotationInterval = Integer.parseInt(rotation);
                }
                catch (NumberFormatException e) {
                    String message = "'org.forgerock.openam.debug.rotation' value can't be parsed: '" + rotation + "'. Please check the configuration file '" + "/debugconfig.properties" + "'.";
                    StdDebugFile.printError(DebugConfigurationFromProperties.class.getSimpleName(), message, e);
                    this.rotationInterval = -1;
                }
            }
            this.validate();
        }
        catch (IOException ex) {
            String message = "Can't load debug file properties. Please check the configuration file '" + debugFilePropertiesPath + "'.";
            throw new InvalidDebugConfigurationException(message);
        }
        finally {
            IOUtils.closeIfNotNull((Closeable)is);
        }
    }

    @Override
    public String getDebugPrefix() {
        return this.debugPrefix;
    }

    @Override
    public String getDebugSuffix() {
        return this.debugSuffix;
    }

    @Override
    public int getRotationInterval() {
        return this.rotationInterval;
    }

    @Override
    public long getRotationFileSizeInByte() {
        return this.maxFileSizeInByte;
    }

    private void validate() throws InvalidDebugConfigurationException {
        if (this.getRotationFileSizeInByte() != -1L) {
            if (this.getRotationFileSizeInByte() <= 0L) {
                throw new InvalidDebugConfigurationException("File size rotation needs to be greater than zero. File size rotation = '" + this.getRotationFileSizeInByte() + "'", null);
            }
            if (this.getDebugSuffix().isEmpty()) {
                throw new InvalidDebugConfigurationException("Log size rotation is enabled (File size rotation = " + this.getRotationFileSizeInByte() + ") but the debug suffix is empty");
            }
            try {
                if (this.validateSuffix(14, 1)) {
                    throw new InvalidDebugConfigurationException("This suffix '" + this.getDebugSuffix() + "' isn't compatible with the file size rotation enable.");
                }
            }
            catch (IllegalArgumentException e) {
                throw new InvalidDebugConfigurationException("Suffix '" + this.getDebugSuffix() + "' can't be parsed.");
            }
        }
        if (this.getRotationInterval() != -1) {
            if (this.getRotationInterval() <= 0) {
                throw new InvalidDebugConfigurationException("Rotation interval needs to be greater than zero. rotationInterval = '" + this.rotationInterval + "'", null);
            }
            if (this.getDebugSuffix().isEmpty()) {
                throw new InvalidDebugConfigurationException("Log time rotation is enabled (rotation interval = " + this.getRotationInterval() + ") but the debug suffix is empty");
            }
            try {
                if (this.validateSuffix(12, this.getRotationInterval())) {
                    throw new InvalidDebugConfigurationException("Suffix '" + this.getDebugSuffix() + "' isn't compatible with the rotation interval requested '" + this.getRotationInterval() + "'.");
                }
            }
            catch (IllegalArgumentException e) {
                throw new InvalidDebugConfigurationException("Suffix '" + this.getDebugSuffix() + "' can't be parsed.");
            }
        }
    }

    private boolean validateSuffix(int field, int amount) throws IllegalArgumentException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getDebugSuffix());
        Calendar cal = Time.getCalendarInstance();
        cal.setTimeInMillis(0L);
        String initialSuffix = dateFormat.format(cal.getTime());
        cal.add(field, amount);
        String suffixAfterOneRotation = dateFormat.format(cal.getTime());
        return suffixAfterOneRotation.equals(initialSuffix);
    }

    public String toString() {
        return "DebugConfigurationFromProperties{debugPrefix='" + this.debugPrefix + '\'' + ", debugSuffix='" + this.debugSuffix + '\'' + ", rotationInterval=" + this.rotationInterval + '}';
    }
}

