/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.debug;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.IDebug;
import com.sun.identity.shared.debug.IDebugProvider;
import com.sun.identity.shared.debug.impl.DebugProviderImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.helpers.MessageFormatter;

public class Debug {
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int MESSAGE = 3;
    public static final int ON = 4;
    public static final String STR_OFF = "off";
    public static final String STR_ERROR = "error";
    public static final String STR_WARNING = "warning";
    public static final String STR_MESSAGE = "message";
    public static final String STR_ON = "on";
    private static Map debugMap = new HashMap();
    private static boolean serviceInitialized = false;
    private static IDebugProvider debugProvider;
    private IDebug debugServiceInstance;

    public static synchronized Debug getInstance(String debugName) {
        IDebug iDebug = Debug.getDebugProvider().getInstance(debugName);
        Debug debug = (Debug)Debug.getDebugMap().get(iDebug.getName());
        if (debug == null) {
            debug = new Debug(iDebug);
            Debug.getDebugMap().put(iDebug.getName(), debug);
        }
        return debug;
    }

    public static Collection getInstances() {
        return Debug.getDebugMap().values();
    }

    private static Map getDebugMap() {
        return debugMap;
    }

    private static void setDebugProvider(IDebugProvider provider) {
        debugProvider = provider;
    }

    static IDebugProvider getDebugProvider() {
        return debugProvider;
    }

    private static synchronized void initialize() {
        if (!serviceInitialized) {
            String providerName = SystemPropertiesManager.get("com.sun.identity.util.debug.provider");
            IDebugProvider provider = null;
            if (providerName != null && providerName.trim().length() > 0) {
                try {
                    provider = (IDebugProvider)Class.forName(providerName).newInstance();
                }
                catch (Throwable e) {
                    System.err.println("error init " + providerName);
                    e.printStackTrace();
                }
            }
            if (provider == null) {
                provider = new DebugProviderImpl();
            }
            Debug.setDebugProvider(provider);
            serviceInitialized = true;
        }
    }

    public String getName() {
        return this.getDebugServiceInstance().getName();
    }

    public boolean messageEnabled() {
        return this.getDebugServiceInstance().messageEnabled();
    }

    public boolean warningEnabled() {
        return this.getDebugServiceInstance().warningEnabled();
    }

    public boolean errorEnabled() {
        return this.getDebugServiceInstance().errorEnabled();
    }

    public int getState() {
        return this.getDebugServiceInstance().getState();
    }

    public void message(String msg) {
        this.getDebugServiceInstance().message(msg, null);
    }

    public void message(String msg, Throwable t) {
        this.getDebugServiceInstance().message(msg, t);
    }

    public void message(String msg, Object ... params) {
        IDebug debug = this.getDebugServiceInstance();
        if (debug.messageEnabled()) {
            String message = MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage();
            if (params.length > 0 && params[params.length - 1] instanceof Throwable) {
                debug.message(message, (Throwable)params[params.length - 1]);
            } else {
                debug.message(message, null);
            }
        }
    }

    public void warning(String msg) {
        this.getDebugServiceInstance().warning(msg, null);
    }

    public void warning(String msg, Throwable t) {
        this.getDebugServiceInstance().warning(msg, t);
    }

    public void warning(String msg, Object ... params) {
        IDebug debug = this.getDebugServiceInstance();
        if (debug.warningEnabled()) {
            String message = MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage();
            if (params.length > 0 && params[params.length - 1] instanceof Throwable) {
                debug.warning(message, (Throwable)params[params.length - 1]);
            } else {
                debug.warning(message, null);
            }
        }
    }

    public void error(String msg) {
        this.getDebugServiceInstance().error(msg, null);
    }

    public void error(String msg, Throwable t) {
        this.getDebugServiceInstance().error(msg, t);
    }

    public void error(String msg, Object ... params) {
        IDebug debug = this.getDebugServiceInstance();
        if (debug.errorEnabled()) {
            String message = MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage();
            if (params.length > 0 && params[params.length - 1] instanceof Throwable) {
                debug.error(message, (Throwable)params[params.length - 1]);
            } else {
                debug.error(message, null);
            }
        }
    }

    public void setDebug(int debugType) {
        this.getDebugServiceInstance().setDebug(debugType);
    }

    public void resetDebug(String mf) {
        this.getDebugServiceInstance().resetDebug(mf);
    }

    public void setDebug(String debugType) {
        this.getDebugServiceInstance().setDebug(debugType);
    }

    public void destroy() {
    }

    private void setDebugServiceInstance(IDebug debugServiceInstance) {
        this.debugServiceInstance = debugServiceInstance;
    }

    private IDebug getDebugServiceInstance() {
        return this.debugServiceInstance;
    }

    private Debug(IDebug debugServiceInstance) {
        this.setDebugServiceInstance(debugServiceInstance);
    }

    static {
        Debug.initialize();
    }
}

