/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.datastruct;

import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.datastruct.ValueNotFoundException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.forgerock.openam.utils.StringUtils;
import org.forgerock.openam.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionHelper {
    private static final String localDsameServer = SystemPropertiesManager.get("com.iplanet.am.server.host");
    private static final Logger logger = LoggerFactory.getLogger(CollectionHelper.class);
    private static final String SEPARATOR = "|";

    public static String getMapAttr(Map<?, ?> map, String name) {
        Set s = (Set)map.get(name);
        String retVal = s == null || s.isEmpty() ? null : (String)s.iterator().next();
        return retVal != null ? retVal.trim() : null;
    }

    public static String getMapAttr(Map map, String name, String defaultValue) {
        String str = CollectionHelper.getMapAttr(map, name);
        return str != null && str.length() > 0 ? str : defaultValue;
    }

    public static String getMapAttrThrows(Map map, String key) throws ValueNotFoundException {
        String str = CollectionHelper.getMapAttr(map, key);
        if (org.apache.commons.lang.StringUtils.isBlank((String)str)) {
            throw new ValueNotFoundException("No value found for key '" + key + "'.");
        }
        return str;
    }

    public static Set<String> getMapSetThrows(Map<String, Set<String>> map, String key) throws ValueNotFoundException {
        if (!map.containsKey(key)) {
            throw new ValueNotFoundException("No value found for key " + key);
        }
        return map.get(key);
    }

    public static Map<java.util.Locale, String> getLocaleMapAttrThrows(Map<String, Set<String>> map, String key) throws ValueNotFoundException {
        Set<String> values = map.get(key);
        if (values == null || values.isEmpty()) {
            throw new ValueNotFoundException("No value found for key '" + key + "'.");
        }
        HashMap<java.util.Locale, String> result = new HashMap<java.util.Locale, String>();
        for (String s : values) {
            if (StringUtils.isBlank(s)) continue;
            String[] parts = s.split(Pattern.quote(SEPARATOR));
            if (parts.length != 2) {
                logger.warn("Config key " + key + " has value in invalid format: " + s);
                continue;
            }
            java.util.Locale locale = Locale.getLocale(parts[0]);
            if (result.containsKey(locale)) {
                logger.warn("Config key " + key + " has multiple entries for locale " + locale.toString());
            }
            result.put(locale, parts[1]);
        }
        return result;
    }

    public static boolean getBooleanMapAttr(Map map, String name, boolean defaultValue) {
        String value = CollectionHelper.getMapAttr(map, name, Boolean.toString(defaultValue));
        return Boolean.parseBoolean(value);
    }

    public static boolean getBooleanMapAttrThrows(Map map, String name) throws ValueNotFoundException {
        String value = CollectionHelper.getMapAttrThrows(map, name);
        Boolean boolValue = Boolean.parseBoolean(value);
        return boolValue;
    }

    public static int getIntMapAttr(Map map, String name, int defaultValue, Debug debug) {
        String valueString = null;
        try {
            valueString = CollectionHelper.getMapAttr(map, name);
            if (org.apache.commons.lang.StringUtils.isBlank((String)valueString)) {
                debug.message("No value found for key '" + name + "' and default value '" + defaultValue + "'  is returned.");
                return defaultValue;
            }
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException nfe) {
            debug.error("Unable to parse " + name + "=" + valueString);
            return defaultValue;
        }
    }

    public static int getIntMapAttrThrows(Map map, String name) throws ValueNotFoundException {
        String valueString = null;
        try {
            valueString = CollectionHelper.getMapAttr(map, name);
            if (org.apache.commons.lang.StringUtils.isBlank((String)valueString)) {
                throw new ValueNotFoundException("No value found for key '" + name + "'.");
            }
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException nfe) {
            throw new ValueNotFoundException("Unable to parse " + name + "=" + valueString);
        }
    }

    public static long getLongMapAttr(Map<String, Set<String>> config, String name, long defaultValue, Debug debug) {
        String valueString = null;
        try {
            valueString = CollectionHelper.getMapAttr(config, name);
            if (org.apache.commons.lang.StringUtils.isBlank((String)valueString)) {
                debug.message("No value found for key '" + name + "' and default value '" + defaultValue + "'  is returned.");
                return defaultValue;
            }
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException nfe) {
            debug.error("Unable to parse " + name + "=" + valueString);
            return defaultValue;
        }
    }

    public static long getLongMapAttrThrows(Map<String, Set<String>> map, String name) throws ValueNotFoundException {
        String valueString = null;
        try {
            valueString = CollectionHelper.getMapAttr(map, name);
            if (org.apache.commons.lang.StringUtils.isBlank((String)valueString)) {
                throw new ValueNotFoundException("No value found for key '" + name + "'.");
            }
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException nfe) {
            throw new ValueNotFoundException("Unable to parse " + name + "=" + valueString);
        }
    }

    public static long getMapAttrAsDateLong(Map<String, Set<String>> config, String name, Logger logger) {
        String valueString = null;
        try {
            valueString = CollectionHelper.getMapAttr(config, name);
            if (org.apache.commons.lang.StringUtils.isBlank((String)valueString)) {
                logger.debug("No value found for key '" + name + "' .");
                return Time.newDate().getTime();
            }
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException nfe) {
            logger.error("Unable to parse " + name + "=" + valueString);
            return Time.newDate().getTime();
        }
    }

    public static String getServerMapAttr(Map map, String attrName) {
        String result = null;
        Set attrValues = (Set)map.get(attrName);
        if (attrValues != null && !attrValues.isEmpty()) {
            if (attrValues.size() == 1) {
                Iterator iter = attrValues.iterator();
                String strServer = (String)iter.next();
                if (strServer != null) {
                    strServer = strServer.trim();
                }
                return strServer;
            }
            Iterator i = attrValues.iterator();
            while (i.hasNext() && result == null) {
                result = (String)i.next();
                if (result == null) continue;
                if ((result = result.trim()).startsWith(localDsameServer)) {
                    int index = result.indexOf(SEPARATOR);
                    if (index != -1) {
                        result = result.substring(index + 1);
                        continue;
                    }
                    result = null;
                    continue;
                }
                result = null;
            }
        }
        return result;
    }

    public static Set<String> getServerMapAttrs(Map<String, Set<String>> map, String attrName) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        Set<String> attrValues = map.get(attrName);
        LinkedHashSet<String> currentServerDefined = new LinkedHashSet<String>();
        LinkedHashSet<String> otherServerDefined = new LinkedHashSet<String>();
        LinkedHashSet<String> nonMatchingServers = new LinkedHashSet<String>();
        for (String attr : attrValues) {
            if (attr == null) continue;
            int index = (attr = attr.trim()).indexOf(SEPARATOR);
            if (index == -1) {
                nonMatchingServers.add(attr);
                continue;
            }
            String currentPrefix = attr.substring(0, index);
            if (currentPrefix.equalsIgnoreCase(localDsameServer)) {
                attr = attr.substring(index + 1);
                currentServerDefined.add(attr);
                continue;
            }
            attr = attr.substring(index + 1);
            otherServerDefined.add(attr);
        }
        ret.addAll(currentServerDefined);
        ret.addAll(nonMatchingServers);
        ret.addAll(otherServerDefined);
        return ret;
    }
}

