/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class BufferedIterator<T>
implements Iterator<T> {
    private final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();
    private volatile boolean done = false;

    public void add(T entry) {
        this.queue.add(entry);
    }

    public void add(List<T> entry) {
        this.queue.addAll(entry);
    }

    public void isDone() {
        this.done = true;
    }

    @Override
    public T next() {
        while (this.hasNext()) {
            try {
                return this.queue.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        return !this.done || !this.queue.isEmpty();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

