/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security.keystore;

import com.sun.identity.security.SecurityDebug;
import com.sun.identity.security.keystore.AMCallbackHandler;
import com.sun.identity.security.keystore.AMX509KeyManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import java.io.File;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.X509KeyManager;

public class AMX509KeyManagerImpl
implements AMX509KeyManager {
    static final String bundleName = "amSecurity";
    static ResourceBundle bundle = null;
    static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    public static Debug debug = SecurityDebug.debug;
    private String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
    private String keyStoreFile = System.getProperty("javax.net.ssl.keyStore", null);
    private String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider", null);
    private static String certAlias = System.getProperty("com.sun.identity.security.keyStore.clientAlias", null);
    private X509KeyManager sunX509KeyManager = null;
    private KeyStore keyStore = null;
    KeyStore.Builder builder = null;
    static String provider = null;
    static String algorithm = null;

    public AMX509KeyManagerImpl() {
        this.sunX509KeyManager = this.initX509KeyManager(this.keyStoreType, this.keyStoreFile, this.keyStoreProvider, null);
    }

    public AMX509KeyManagerImpl(String ksType, String ksFile, String ksProvider, AMCallbackHandler cbHandle) {
        this.keyStoreType = ksType;
        this.keyStoreFile = ksFile;
        this.keyStoreProvider = ksProvider;
        this.sunX509KeyManager = this.initX509KeyManager(this.keyStoreType, this.keyStoreFile, this.keyStoreProvider, cbHandle);
    }

    public X509KeyManager initX509KeyManager(String ksType, String ksFile, String ksProvider, AMCallbackHandler cbHandle) {
        KeyManagerFactory kmf = null;
        try {
            bundle = amCache.getResBundle(bundleName, Locale.getDefault());
            KeyStore.CallbackHandlerProtection callback = null;
            if (cbHandle != null) {
                callback = new KeyStore.CallbackHandlerProtection(cbHandle);
            } else {
                String passwdPrompt = bundle.getString("KeyStorePrompt");
                callback = new KeyStore.CallbackHandlerProtection(new AMCallbackHandler(passwdPrompt));
            }
            if (ksType.equalsIgnoreCase("JKS") || ksType.equalsIgnoreCase("PKCS12")) {
                this.builder = KeyStore.Builder.newInstance(ksType, Security.getProvider(ksProvider), new File(ksFile), callback);
            } else if (this.keyStoreType.equalsIgnoreCase("PKCS11")) {
                this.builder = KeyStore.Builder.newInstance(ksType, Security.getProvider(ksProvider), callback);
            }
            KeyStoreBuilderParameters param = new KeyStoreBuilderParameters(this.builder);
            kmf = KeyManagerFactory.getInstance(algorithm, provider);
            kmf.init(param);
        }
        catch (Exception e) {
            debug.error(e.toString());
        }
        return (X509KeyManager)kmf.getKeyManagers()[0];
    }

    @Override
    public void setAlias(String alias) {
        certAlias = alias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket sock) {
        if (certAlias != null && certAlias.length() > 0) {
            return certAlias;
        }
        return this.sunX509KeyManager.chooseClientAlias(keyType, issuers, sock);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket sock) {
        return this.sunX509KeyManager.chooseServerAlias(keyType, issuers, sock);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.sunX509KeyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.sunX509KeyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] certchain = null;
        try {
            KeyStore keystore = this.builder.getKeyStore();
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keystore.getEntry(alias, this.builder.getProtectionParameter(alias));
            certchain = entry != null ? (X509Certificate[])entry.getCertificateChain() : this.sunX509KeyManager.getCertificateChain(alias);
        }
        catch (Exception e) {
            debug.error("Error in getting certificate chain from keystore." + e.toString());
        }
        return certchain;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        PrivateKey pkey = null;
        try {
            KeyStore keystore = this.builder.getKeyStore();
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keystore.getEntry(alias, this.builder.getProtectionParameter(alias));
            pkey = entry != null ? entry.getPrivateKey() : this.sunX509KeyManager.getPrivateKey(alias);
        }
        catch (Exception e) {
            debug.error("Error in getting private key from keystore." + e.toString());
        }
        return pkey;
    }

    static {
        Provider[] sProviders = Security.getProviders();
        for (int i = 0; i < sProviders.length; ++i) {
            if (!sProviders[i].getName().equalsIgnoreCase("IBMJSSE2")) continue;
            provider = "IBMJSSE2";
            algorithm = "NewIbmX509";
        }
        if (provider == null) {
            provider = "SunJSSE";
            algorithm = "NewSunX509";
        }
    }
}

