/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security;

import com.sun.identity.shared.encode.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class DataEncryptor {
    private static final String ENCRYPTED_DATA = "EncryptedData";
    private static final String ENCRYPTED_KEY = "EncryptedKey";
    private static final byte[] ___y = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
    private static final int ITERATION_COUNT = 5;
    private static PBEParameterSpec pbeParameterSpec = new PBEParameterSpec(___y, 5);

    public static String encryptWithAsymmetricKey(String data, String encryptionAlgorithm, int encryptionStrength, Key encKey) throws Exception {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(encryptionAlgorithm);
            if (encryptionStrength != 0) {
                keygen.init(encryptionStrength);
            }
            SecretKey sKey = keygen.generateKey();
            Cipher cipher = Cipher.getInstance(encryptionAlgorithm);
            cipher.init(1, sKey);
            byte[] encData = cipher.doFinal(data.getBytes("UTF-8"));
            cipher = Cipher.getInstance(encKey.getAlgorithm());
            cipher.init(3, encKey);
            byte[] keyWrap = cipher.wrap(sKey);
            byte[] encDataPad = DataEncryptor.wrapKeyWithEncryptedData(encData, keyWrap);
            return Base64.encode(encDataPad);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new Exception(nse.getMessage());
        }
        catch (NoSuchPaddingException npe) {
            throw new Exception(npe.getMessage());
        }
        catch (InvalidKeyException ike) {
            throw new Exception(ike.getMessage());
        }
        catch (UnsupportedEncodingException uae) {
            throw new Exception(uae.getMessage());
        }
    }

    public static String decryptWithAsymmetricKey(String data, String encAlgorithm, Key encKey) throws Exception {
        try {
            byte[] tmp = Base64.decode(data);
            Map map = DataEncryptor.unwrapKeyWithEncodedData(tmp);
            byte[] encData = (byte[])map.get(ENCRYPTED_DATA);
            byte[] keyData = (byte[])map.get(ENCRYPTED_KEY);
            Cipher cipher = Cipher.getInstance(encKey.getAlgorithm());
            cipher.init(4, encKey);
            Key secretKey = cipher.unwrap(keyData, encAlgorithm, 3);
            cipher = Cipher.getInstance(encAlgorithm);
            cipher.init(2, secretKey);
            byte[] decryptedData = cipher.doFinal(encData);
            return Base64.encode(decryptedData);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new Exception(nse.getMessage());
        }
        catch (InvalidKeyException ike) {
            throw new Exception(ike.getMessage());
        }
    }

    public static String encryptWithSymmetricKey(String data, String encAlgorithm, String secret) throws Exception {
        try {
            String algorithm = encAlgorithm;
            if (!algorithm.startsWith("PBEWith")) {
                algorithm = "PBEWithMD5And" + encAlgorithm;
            }
            SecretKeyFactory skFactory = SecretKeyFactory.getInstance(algorithm);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(secret.toCharArray());
            SecretKey sKey = skFactory.generateSecret(pbeKeySpec);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, (Key)sKey, pbeParameterSpec);
            byte[] encData = cipher.doFinal(data.getBytes("UTF-8"));
            encData = DataEncryptor.addPrefix(encData);
            return Base64.encode(encData);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new Exception(nse.getMessage());
        }
    }

    public static String decryptWithSymmetricKey(String data, String encAlgorithm, String secret) throws Exception {
        try {
            String algorithm = encAlgorithm;
            if (!algorithm.startsWith("PBEWith")) {
                algorithm = "PBEWithMD5And" + encAlgorithm;
            }
            SecretKeyFactory skFactory = SecretKeyFactory.getInstance(algorithm);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(secret.toCharArray());
            SecretKey sKey = skFactory.generateSecret(pbeKeySpec);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, (Key)sKey, pbeParameterSpec);
            byte[] tmp = Base64.decode(data);
            byte[] encData = DataEncryptor.removePrefix(tmp);
            byte[] decData = cipher.doFinal(encData);
            return Base64.encode(decData);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new Exception(nse.getMessage());
        }
    }

    private static byte[] addPrefix(byte[] encData) {
        int i;
        int length = encData.length;
        byte[] result = new byte[9 + length];
        byte[] encrypted = new String("ENCRYPTED").getBytes();
        for (i = 0; i < 9; ++i) {
            result[i] = encrypted[i];
        }
        for (i = 0; i < length; ++i) {
            result[9 + i] = encData[i];
        }
        return result;
    }

    private static byte[] removePrefix(byte[] data) {
        int length = data.length - 9;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = data[9 + i];
        }
        return result;
    }

    private static byte[] wrapKeyWithEncryptedData(byte[] data, byte[] key) {
        int i;
        int i2;
        int dataLength = data.length;
        int keyLength = key.length;
        byte[] result = new byte[17 + data.length + key.length];
        byte[] encrypted = new String("ENCRYPTED").getBytes();
        for (int i3 = 0; i3 < 9; ++i3) {
            result[i3] = encrypted[i3];
        }
        byte[] datasize = DataEncryptor.intToByteArray(dataLength);
        for (i2 = 0; i2 < 4; ++i2) {
            result[i2 + 9] = datasize[i2];
        }
        for (i2 = 0; i2 < dataLength; ++i2) {
            result[i2 + 13] = data[i2];
        }
        byte[] keysize = DataEncryptor.intToByteArray(keyLength);
        for (i = 0; i < 4; ++i) {
            result[i + 13 + dataLength] = keysize[i];
        }
        for (i = 0; i < keyLength; ++i) {
            result[i + 17 + dataLength] = key[i];
        }
        return result;
    }

    private static Map unwrapKeyWithEncodedData(byte[] decodeData) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        byte[] dataLength = new byte[4];
        int j = 0;
        for (int i = 9; i < 13; ++i) {
            dataLength[j] = decodeData[i];
            ++j;
        }
        int encDataLength = DataEncryptor.byteArrayToInt(dataLength);
        byte[] encData = new byte[encDataLength];
        j = 0;
        for (int i = 13; i < encDataLength + 13; ++i) {
            encData[j] = decodeData[i];
            ++j;
        }
        map.put(ENCRYPTED_DATA, encData);
        byte[] keyLen = new byte[4];
        int startIndex = 13 + encDataLength;
        int endIndex = startIndex + 4;
        j = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            keyLen[j] = decodeData[i];
            ++j;
        }
        int keyDataLength = DataEncryptor.byteArrayToInt(keyLen);
        endIndex = (startIndex += 4) + keyDataLength;
        byte[] keyData = new byte[keyDataLength];
        j = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            keyData[j] = decodeData[i];
            ++j;
        }
        map.put(ENCRYPTED_KEY, keyData);
        return map;
    }

    private static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    private static final int byteArrayToInt(byte[] b) {
        return (b[0] << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
    }
}

